/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.time.AbstractFormatCache$ArrayKey;
import org.apache.commons.lang3.time.TimeZones;

abstract class AbstractFormatCache<F extends Format> {
    static final int NONE = -1;
    private static final ConcurrentMap<AbstractFormatCache$ArrayKey, String> dateTimeInstanceCache = new ConcurrentHashMap<AbstractFormatCache$ArrayKey, String>(7);
    private final ConcurrentMap<AbstractFormatCache$ArrayKey, F> instanceCache = new ConcurrentHashMap<AbstractFormatCache$ArrayKey, F>(7);

    AbstractFormatCache() {
    }

    static void clear() {
        dateTimeInstanceCache.clear();
    }

    static String getPatternForStyle(Integer n2, Integer n3, Locale locale) {
        locale = LocaleUtils.toLocale(locale);
        AbstractFormatCache$ArrayKey abstractFormatCache$ArrayKey2 = new AbstractFormatCache$ArrayKey(n2, n3, locale);
        return dateTimeInstanceCache.computeIfAbsent(abstractFormatCache$ArrayKey2, abstractFormatCache$ArrayKey -> {
            try {
                n2 = n2 == null ? DateFormat.getTimeInstance(n3, locale) : (n3 == null ? DateFormat.getDateInstance(n2, locale) : DateFormat.getDateTimeInstance(n2, n3, locale));
                return ((SimpleDateFormat)((Object)n2)).toPattern();
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        });
    }

    void clearInstance() {
        this.instanceCache.clear();
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    F getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, null, timeZone, locale);
    }

    F getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, (Integer)n3, timeZone, locale);
    }

    private F getDateTimeInstance(Integer object, Integer n2, TimeZone timeZone, Locale locale) {
        locale = LocaleUtils.toLocale(locale);
        object = AbstractFormatCache.getPatternForStyle((Integer)object, n2, locale);
        return this.getInstance((String)object, timeZone, locale);
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public F getInstance(String string, TimeZone timeZone, Locale locale) {
        Objects.requireNonNull(string, "pattern");
        timeZone = TimeZones.toTimeZone(timeZone);
        locale = LocaleUtils.toLocale(locale);
        AbstractFormatCache$ArrayKey abstractFormatCache$ArrayKey2 = new AbstractFormatCache$ArrayKey(string, timeZone, locale);
        return (F)this.instanceCache.computeIfAbsent(abstractFormatCache$ArrayKey2, abstractFormatCache$ArrayKey -> this.createInstance(string, timeZone, locale));
    }

    F getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)n2, timeZone, locale);
    }
}

