/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DurationFormatUtils$Token;

public class DurationFormatUtils {
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTES = 60;
    private static final int HOURS_PER_DAY = 24;
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    static final String y = "y";
    static final String M = "M";
    static final String d = "d";
    static final String H = "H";
    static final String m = "m";
    static final String s = "s";
    static final String S = "S";

    static String format(DurationFormatUtils$Token[] durationFormatUtils$TokenArray, long l2, long l3, long l4, long l5, long l6, long l7, long l8, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        boolean bl3 = false;
        int n3 = -1;
        boolean bl4 = false;
        int n4 = -1;
        boolean bl5 = false;
        for (DurationFormatUtils$Token durationFormatUtils$Token : durationFormatUtils$TokenArray) {
            Object object = durationFormatUtils$Token.getValue();
            boolean bl6 = object instanceof StringBuilder;
            int n5 = durationFormatUtils$Token.getCount();
            if (n4 != DurationFormatUtils$Token.access$000(durationFormatUtils$Token)) {
                n4 = DurationFormatUtils$Token.access$000(durationFormatUtils$Token);
                if (n4 >= 0) {
                    n3 = stringBuilder.length();
                    bl3 = false;
                    bl5 = true;
                    bl4 = false;
                } else {
                    bl5 = false;
                }
            }
            if (bl6) {
                if (!bl5 || !bl3) {
                    stringBuilder.append(object.toString());
                }
            } else if (object.equals(y)) {
                n2 = 0;
                boolean bl7 = bl3 = l2 == 0L;
                if (!bl5 || !bl3) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l2, bl2, n5));
                }
            } else if (object.equals(M)) {
                n2 = 0;
                boolean bl8 = bl3 = l3 == 0L;
                if (!bl5 || !bl3) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l3, bl2, n5));
                }
            } else if (object.equals(d)) {
                n2 = 0;
                boolean bl9 = bl3 = l4 == 0L;
                if (!bl5 || !bl3) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l4, bl2, n5));
                }
            } else if (object.equals(H)) {
                n2 = 0;
                boolean bl10 = bl3 = l5 == 0L;
                if (!bl5 || !bl3) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l5, bl2, n5));
                }
            } else if (object.equals(m)) {
                n2 = 0;
                boolean bl11 = bl3 = l6 == 0L;
                if (!bl5 || !bl3) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l6, bl2, n5));
                }
            } else if (object.equals(s)) {
                n2 = 1;
                boolean bl12 = bl3 = l7 == 0L;
                if (!bl5 || !bl3) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l7, bl2, n5));
                }
            } else if (object.equals(S)) {
                boolean bl13 = bl3 = l8 == 0L;
                if (!bl5 || !bl3) {
                    if (n2 != 0) {
                        n2 = bl2 ? Math.max(3, n5) : 3;
                        stringBuilder.append(DurationFormatUtils.paddedValue(l8, true, n2));
                    } else {
                        stringBuilder.append(DurationFormatUtils.paddedValue(l8, bl2, n5));
                    }
                }
                n2 = 0;
            }
            if (!bl5 || bl6 || bl4) continue;
            bl4 = true;
            if (!bl3) continue;
            stringBuilder.delete(n3, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String formatDuration(long l2, String string) {
        return DurationFormatUtils.formatDuration(l2, string, true);
    }

    public static String formatDuration(long l2, String durationFormatUtils$TokenArray, boolean bl2) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, l2, "durationMillis must not be negative");
        durationFormatUtils$TokenArray = DurationFormatUtils.lexx((String)durationFormatUtils$TokenArray);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, d)) {
            l3 = l7 / 86400000L;
            l7 -= l3 * 86400000L;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, H)) {
            l4 = l7 / 3600000L;
            l7 -= l4 * 3600000L;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, m)) {
            l5 = l7 / 60000L;
            l7 -= l5 * 60000L;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, s)) {
            l6 = l7 / 1000L;
            l7 -= l6 * 1000L;
        }
        return DurationFormatUtils.format(durationFormatUtils$TokenArray, 0L, 0L, l3, l4, l5, l6, l7, bl2);
    }

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDurationWords(long l2, boolean bl2, boolean bl3) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl2) {
            string = string2 = " " + string2;
            if ((string = Strings.CS.replaceOnce(string, " 0 days", "")).length() != string2.length()) {
                string = string2 = string;
                if ((string = Strings.CS.replaceOnce(string, " 0 hours", "")).length() != string2.length()) {
                    string = string2 = string;
                    string2 = string = Strings.CS.replaceOnce(string, " 0 minutes", "");
                }
            }
            if (!string2.isEmpty()) {
                string2 = string2.substring(1);
            }
        }
        if (bl3) {
            string = string2;
            if ((string = Strings.CS.replaceOnce(string, " 0 seconds", "")).length() != string2.length()) {
                string = string2 = string;
                if ((string = Strings.CS.replaceOnce(string, " 0 minutes", "")).length() != string2.length()) {
                    string = string2 = string;
                    if ((string = Strings.CS.replaceOnce(string, " 0 hours", "")).length() != string2.length()) {
                        string2 = string;
                        string2 = Strings.CS.replaceOnce(string2, " 0 days", "");
                    }
                }
            }
        }
        string = string2 = " " + string2;
        string = string2 = Strings.CS.replaceOnce(string, " 1 seconds", " 1 second");
        string = string2 = Strings.CS.replaceOnce(string, " 1 minutes", " 1 minute");
        string = string2 = Strings.CS.replaceOnce(string, " 1 hours", " 1 hour");
        string2 = Strings.CS.replaceOnce(string, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriod(long l2, long l3, String string) {
        return DurationFormatUtils.formatPeriod(l2, l3, string, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String durationFormatUtils$TokenArray, boolean bl2, TimeZone timeZone) {
        Validate.isTrue(l2 <= l3, "startMillis must not be greater than endMillis", new Object[0]);
        durationFormatUtils$TokenArray = DurationFormatUtils.lexx((String)durationFormatUtils$TokenArray);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        long l4 = calendar2.get(14) - calendar.get(14);
        int n2 = calendar2.get(13) - calendar.get(13);
        int n3 = calendar2.get(12) - calendar.get(12);
        int n4 = calendar2.get(11) - calendar.get(11);
        int n5 = calendar2.get(5) - calendar.get(5);
        int n6 = calendar2.get(2) - calendar.get(2);
        int n7 = calendar2.get(1) - calendar.get(1);
        while (l4 < 0L) {
            l4 += 1000L;
            --n2;
        }
        while (n2 < 0) {
            n2 += 60;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 24;
            --n5;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, M)) {
            while (n5 < 0) {
                n5 += calendar.getActualMaximum(5);
                --n6;
                calendar.add(2, 1);
            }
            while (n6 < 0) {
                n6 += 12;
                --n7;
            }
            if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, y) && n7 != 0) {
                while (n7 != 0) {
                    n6 += n7 * 12;
                    n7 = 0;
                }
            }
        } else {
            if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, y)) {
                n7 = calendar2.get(1);
                if (n6 < 0) {
                    --n7;
                }
                while (calendar.get(1) != n7) {
                    n5 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n5;
                    }
                    calendar.add(1, 1);
                    n5 += calendar.get(6);
                }
                n7 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n5 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n6 = 0;
            while (n5 < 0) {
                n5 += calendar.getActualMaximum(5);
                --n6;
                calendar.add(2, 1);
            }
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, d)) {
            n4 += n5 * 24;
            n5 = 0;
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, H)) {
            n3 += n4 * 60;
            n4 = 0;
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, m)) {
            n2 += n3 * 60;
            n3 = 0;
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, s)) {
            l4 += 1000L * (long)n2;
            n2 = 0;
        }
        return DurationFormatUtils.format(durationFormatUtils$TokenArray, n7, n6, n5, n4, n3, n2, l4, bl2);
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    static DurationFormatUtils$Token[] lexx(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(string.length());
        boolean bl2 = false;
        Object object = null;
        Object object2 = null;
        boolean bl3 = false;
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2 && c2 != '\'') {
                ((StringBuilder)object).append(c2);
                continue;
            }
            String string2 = null;
            switch (c2) {
                case '[': {
                    if (bl3) {
                        throw new IllegalArgumentException("Nested optional block at index: " + i2);
                    }
                    ++n2;
                    bl3 = true;
                    break;
                }
                case ']': {
                    if (!bl3) {
                        throw new IllegalArgumentException("Attempting to close unopened optional block at index: " + i2);
                    }
                    bl3 = false;
                    break;
                }
                case '\'': {
                    if (bl2) {
                        object = null;
                        bl2 = false;
                        break;
                    }
                    object = new StringBuilder();
                    arrayList.add(new DurationFormatUtils$Token((CharSequence)object, bl3, n2));
                    bl2 = true;
                    break;
                }
                case 'y': {
                    string2 = y;
                    break;
                }
                case 'M': {
                    string2 = M;
                    break;
                }
                case 'd': {
                    string2 = d;
                    break;
                }
                case 'H': {
                    string2 = H;
                    break;
                }
                case 'm': {
                    string2 = m;
                    break;
                }
                case 's': {
                    string2 = s;
                    break;
                }
                case 'S': {
                    string2 = S;
                    break;
                }
                default: {
                    if (object == null) {
                        object = new StringBuilder();
                        arrayList.add(new DurationFormatUtils$Token((CharSequence)object, bl3, n2));
                    }
                    ((StringBuilder)object).append(c2);
                }
            }
            if (string2 == null) continue;
            if (object2 != null && ((DurationFormatUtils$Token)object2).getValue().equals(string2)) {
                ((DurationFormatUtils$Token)object2).increment();
            } else {
                object = new DurationFormatUtils$Token(string2, bl3, n2);
                arrayList.add(object);
                object2 = object;
            }
            object = null;
        }
        if (bl2) {
            throw new IllegalArgumentException("Unmatched quote in format: " + string);
        }
        if (bl3) {
            throw new IllegalArgumentException("Unmatched optional in format: " + string);
        }
        return arrayList.toArray(DurationFormatUtils$Token.access$100());
    }

    private static String paddedValue(long l2, boolean bl2, int n2) {
        String string = Long.toString(l2);
        if (bl2) {
            return StringUtils.leftPad(string, n2, '0');
        }
        return string;
    }

    @Deprecated
    public DurationFormatUtils() {
    }
}

