/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.GmtTimeZone;

public class FastTimeZone {
    private static final Pattern GMT_PATTERN = Pattern.compile("^(?:(?i)GMT)?([+-])?(\\d\\d?)?(:?(\\d\\d?))?$");
    private static final TimeZone GREENWICH = new GmtTimeZone(false, 0, 0);

    public static TimeZone getGmtTimeZone() {
        return GREENWICH;
    }

    public static TimeZone getGmtTimeZone(String object) {
        if ("Z".equals(object) || "UTC".equals(object)) {
            return GREENWICH;
        }
        if (((Matcher)(object = GMT_PATTERN.matcher((CharSequence)object))).matches()) {
            int n2 = FastTimeZone.parseInt(((Matcher)object).group(2));
            int n3 = FastTimeZone.parseInt(((Matcher)object).group(4));
            if (n2 == 0 && n3 == 0) {
                return GREENWICH;
            }
            return new GmtTimeZone(FastTimeZone.parseSign(((Matcher)object).group(1)), n2, n3);
        }
        return null;
    }

    public static TimeZone getTimeZone(String string) {
        TimeZone timeZone = FastTimeZone.getGmtTimeZone(string);
        if (timeZone != null) {
            return timeZone;
        }
        return TimeZone.getTimeZone(string);
    }

    private static int parseInt(String string) {
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    private static boolean parseSign(String string) {
        return string != null && string.charAt(0) == '-';
    }

    private FastTimeZone() {
    }
}

