/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

final class GmtTimeZone
extends TimeZone {
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    static final long serialVersionUID = 1L;
    private final int offset;
    private final String zoneId;

    private static StringBuilder twoDigits(StringBuilder stringBuilder, int n2) {
        return stringBuilder.append((char)(48 + n2 / 10)).append((char)(48 + n2 % 10));
    }

    GmtTimeZone(boolean bl2, int n2, int n3) {
        if (n2 >= 24) {
            throw new IllegalArgumentException(n2 + " hours out of range");
        }
        if (n3 >= 60) {
            throw new IllegalArgumentException(n3 + " minutes out of range");
        }
        int n4 = (n3 + n2 * 60) * 60000;
        this.offset = bl2 ? -n4 : n4;
        this.zoneId = GmtTimeZone.twoDigits(GmtTimeZone.twoDigits(new StringBuilder(9).append("GMT").append(bl2 ? (char)'-' : '+'), n2).append(':'), n3).toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GmtTimeZone)) {
            return false;
        }
        object = (GmtTimeZone)object;
        return this.offset == ((GmtTimeZone)object).offset && Objects.equals(this.zoneId, ((GmtTimeZone)object).zoneId);
    }

    @Override
    public final String getID() {
        return this.zoneId;
    }

    @Override
    public final int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.offset;
    }

    @Override
    public final int getRawOffset() {
        return this.offset;
    }

    public final int hashCode() {
        return Objects.hash(this.offset, this.zoneId);
    }

    @Override
    public final boolean inDaylightTime(Date date) {
        return false;
    }

    @Override
    public final void setRawOffset(int n2) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return "[GmtTimeZone id=\"" + this.zoneId + "\",offset=" + this.offset + ']';
    }

    @Override
    public final boolean useDaylightTime() {
        return false;
    }
}

