/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.STATELESS)
public interface DnsResolver {
    public InetAddress[] resolve(String var1) throws UnknownHostException;

    public String resolveCanonicalHostname(String var1) throws UnknownHostException;

    default public List<InetSocketAddress> resolve(String string, int n2) throws UnknownHostException {
        InetAddress[] inetAddressArray = this.resolve(string);
        if (inetAddressArray == null) {
            return Collections.singletonList(InetSocketAddress.createUnresolved(string, n2));
        }
        return Arrays.stream(inetAddressArray).map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, n2)).collect(Collectors.toList());
    }
}

