/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;

public final class SimpleBody {
    private final byte[] bodyAsBytes;
    private final String bodyAsText;
    private final ContentType contentType;

    SimpleBody(byte[] byArray, String string, ContentType contentType) {
        this.bodyAsBytes = byArray;
        this.bodyAsText = string;
        this.contentType = contentType;
    }

    static SimpleBody create(String object, ContentType contentType) {
        Args.notNull(object, "Body");
        if (((String)object).length() > 2048) {
            return new SimpleBody(null, (String)object, contentType);
        }
        Charset charset = (contentType != null ? contentType : ContentType.DEFAULT_TEXT).getCharset();
        object = ((String)object).getBytes(charset != null ? charset : StandardCharsets.US_ASCII);
        return new SimpleBody((byte[])object, null, contentType);
    }

    static SimpleBody create(byte[] byArray, ContentType contentType) {
        Args.notNull(byArray, "Body");
        return new SimpleBody(byArray, null, contentType);
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    public final byte[] getBodyBytes() {
        if (this.bodyAsBytes != null) {
            return this.bodyAsBytes;
        }
        if (this.bodyAsText != null) {
            Charset charset = (this.contentType != null ? this.contentType : ContentType.DEFAULT_TEXT).getCharset();
            return this.bodyAsText.getBytes(charset != null ? charset : StandardCharsets.US_ASCII);
        }
        return null;
    }

    public final String getBodyText() {
        if (this.bodyAsBytes != null) {
            Charset charset = (this.contentType != null ? this.contentType : ContentType.DEFAULT_TEXT).getCharset();
            return new String(this.bodyAsBytes, charset != null ? charset : StandardCharsets.US_ASCII);
        }
        return this.bodyAsText;
    }

    public final boolean isText() {
        return this.bodyAsText != null;
    }

    public final boolean isBytes() {
        return this.bodyAsBytes != null;
    }

    public final String toString() {
        return "SimpleBody{content length=" + (this.bodyAsBytes != null ? Integer.valueOf(this.bodyAsBytes.length) : "chunked") + ", content type=" + this.contentType + "}";
    }
}

