/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.net.URI;
import java.util.Iterator;
import org.apache.hc.client5.http.async.methods.ConfigurableHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public final class SimpleHttpRequest
extends ConfigurableHttpRequest {
    private static final long serialVersionUID = 1L;
    private SimpleBody body;

    public static SimpleHttpRequest create(String string, String string2) {
        return new SimpleHttpRequest(string, string2);
    }

    public static SimpleHttpRequest create(String string, URI uRI) {
        return new SimpleHttpRequest(string, uRI);
    }

    public static SimpleHttpRequest create(Method method, URI uRI) {
        return new SimpleHttpRequest(method, uRI);
    }

    public static SimpleHttpRequest create(Method method, HttpHost httpHost, String string) {
        return new SimpleHttpRequest(method, httpHost, string);
    }

    public static SimpleHttpRequest create(String string, String string2, URIAuthority uRIAuthority, String string3) {
        return new SimpleHttpRequest(string, string2, uRIAuthority, string3);
    }

    @Deprecated
    public static SimpleHttpRequest copy(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "HTTP request");
        SimpleHttpRequest simpleHttpRequest = new SimpleHttpRequest(httpRequest.getMethod(), httpRequest.getRequestUri());
        simpleHttpRequest.setVersion(httpRequest.getVersion());
        Iterator<Header> iterator = httpRequest.headerIterator();
        while (iterator.hasNext()) {
            simpleHttpRequest.addHeader(iterator.next());
        }
        simpleHttpRequest.setScheme(httpRequest.getScheme());
        simpleHttpRequest.setAuthority(httpRequest.getAuthority());
        return simpleHttpRequest;
    }

    public SimpleHttpRequest(String string, String string2) {
        super(string, string2);
    }

    public SimpleHttpRequest(String string, HttpHost httpHost, String string2) {
        super(string, httpHost, string2);
    }

    public SimpleHttpRequest(String string, URI uRI) {
        super(string, uRI);
    }

    public SimpleHttpRequest(Method method, URI uRI) {
        this(method.name(), uRI);
    }

    public SimpleHttpRequest(Method method, HttpHost httpHost, String string) {
        this(method.name(), httpHost, string);
    }

    public SimpleHttpRequest(String string, String string2, URIAuthority uRIAuthority, String string3) {
        super(string, string2, uRIAuthority, string3);
    }

    public final void setBody(SimpleBody simpleBody) {
        this.body = simpleBody;
    }

    public final void setBody(byte[] byArray, ContentType contentType) {
        this.body = SimpleBody.create(byArray, contentType);
    }

    public final void setBody(String string, ContentType contentType) {
        this.body = SimpleBody.create(string, contentType);
    }

    public final SimpleBody getBody() {
        return this.body;
    }

    public final ContentType getContentType() {
        if (this.body != null) {
            return this.body.getContentType();
        }
        return null;
    }

    public final String getBodyText() {
        if (this.body != null) {
            return this.body.getBodyText();
        }
        return null;
    }

    public final byte[] getBodyBytes() {
        if (this.body != null) {
            return this.body.getBodyBytes();
        }
        return null;
    }
}

