/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.client5.http.async.methods.ConfigurableHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apache.hc.core5.util.Args;

public class SimpleRequestBuilder
extends AbstractRequestBuilder<SimpleHttpRequest> {
    private SimpleBody body;
    private RequestConfig requestConfig;

    SimpleRequestBuilder(String string) {
        super(string);
    }

    SimpleRequestBuilder(Method method) {
        super(method);
    }

    SimpleRequestBuilder(String string, URI uRI) {
        super(string, uRI);
    }

    SimpleRequestBuilder(Method method, URI uRI) {
        super(method, uRI);
    }

    SimpleRequestBuilder(Method method, String string) {
        super(method, string);
    }

    SimpleRequestBuilder(String string, String string2) {
        super(string, string2);
    }

    public static SimpleRequestBuilder create(String string) {
        Args.notBlank(string, "HTTP method");
        return new SimpleRequestBuilder(string);
    }

    public static SimpleRequestBuilder create(Method method) {
        Args.notNull(method, "HTTP method");
        return new SimpleRequestBuilder(method);
    }

    public static SimpleRequestBuilder get() {
        return new SimpleRequestBuilder(Method.GET);
    }

    public static SimpleRequestBuilder get(URI uRI) {
        return new SimpleRequestBuilder(Method.GET, uRI);
    }

    public static SimpleRequestBuilder get(String string) {
        return new SimpleRequestBuilder(Method.GET, string);
    }

    public static SimpleRequestBuilder head() {
        return new SimpleRequestBuilder(Method.HEAD);
    }

    public static SimpleRequestBuilder head(URI uRI) {
        return new SimpleRequestBuilder(Method.HEAD, uRI);
    }

    public static SimpleRequestBuilder head(String string) {
        return new SimpleRequestBuilder(Method.HEAD, string);
    }

    public static SimpleRequestBuilder patch() {
        return new SimpleRequestBuilder(Method.PATCH);
    }

    public static SimpleRequestBuilder patch(URI uRI) {
        return new SimpleRequestBuilder(Method.PATCH, uRI);
    }

    public static SimpleRequestBuilder patch(String string) {
        return new SimpleRequestBuilder(Method.PATCH, string);
    }

    public static SimpleRequestBuilder post() {
        return new SimpleRequestBuilder(Method.POST);
    }

    public static SimpleRequestBuilder post(URI uRI) {
        return new SimpleRequestBuilder(Method.POST, uRI);
    }

    public static SimpleRequestBuilder post(String string) {
        return new SimpleRequestBuilder(Method.POST, string);
    }

    public static SimpleRequestBuilder put() {
        return new SimpleRequestBuilder(Method.PUT);
    }

    public static SimpleRequestBuilder put(URI uRI) {
        return new SimpleRequestBuilder(Method.PUT, uRI);
    }

    public static SimpleRequestBuilder put(String string) {
        return new SimpleRequestBuilder(Method.PUT, string);
    }

    public static SimpleRequestBuilder delete() {
        return new SimpleRequestBuilder(Method.DELETE);
    }

    public static SimpleRequestBuilder delete(URI uRI) {
        return new SimpleRequestBuilder(Method.DELETE, uRI);
    }

    public static SimpleRequestBuilder delete(String string) {
        return new SimpleRequestBuilder(Method.DELETE, string);
    }

    public static SimpleRequestBuilder trace() {
        return new SimpleRequestBuilder(Method.TRACE);
    }

    public static SimpleRequestBuilder trace(URI uRI) {
        return new SimpleRequestBuilder(Method.TRACE, uRI);
    }

    public static SimpleRequestBuilder trace(String string) {
        return new SimpleRequestBuilder(Method.TRACE, string);
    }

    public static SimpleRequestBuilder options() {
        return new SimpleRequestBuilder(Method.OPTIONS);
    }

    public static SimpleRequestBuilder options(URI uRI) {
        return new SimpleRequestBuilder(Method.OPTIONS, uRI);
    }

    public static SimpleRequestBuilder options(String string) {
        return new SimpleRequestBuilder(Method.OPTIONS, string);
    }

    public static SimpleRequestBuilder copy(SimpleHttpRequest simpleHttpRequest) {
        Args.notNull(simpleHttpRequest, "HTTP request");
        SimpleRequestBuilder simpleRequestBuilder = new SimpleRequestBuilder(simpleHttpRequest.getMethod());
        simpleRequestBuilder.digest(simpleHttpRequest);
        return simpleRequestBuilder;
    }

    public static SimpleRequestBuilder copy(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "HTTP request");
        SimpleRequestBuilder simpleRequestBuilder = new SimpleRequestBuilder(httpRequest.getMethod());
        simpleRequestBuilder.digest(httpRequest);
        return simpleRequestBuilder;
    }

    protected void digest(SimpleHttpRequest simpleHttpRequest) {
        super.digest(simpleHttpRequest);
        this.setBody(simpleHttpRequest.getBody());
    }

    @Override
    protected void digest(HttpRequest httpRequest) {
        super.digest(httpRequest);
    }

    @Override
    public SimpleRequestBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    public SimpleRequestBuilder setUri(URI uRI) {
        super.setUri(uRI);
        return this;
    }

    public SimpleRequestBuilder setUri(String string) {
        super.setUri(string);
        return this;
    }

    public SimpleRequestBuilder setScheme(String string) {
        super.setScheme(string);
        return this;
    }

    public SimpleRequestBuilder setAuthority(URIAuthority uRIAuthority) {
        super.setAuthority(uRIAuthority);
        return this;
    }

    public SimpleRequestBuilder setHttpHost(HttpHost httpHost) {
        super.setHttpHost(httpHost);
        return this;
    }

    public SimpleRequestBuilder setPath(String string) {
        super.setPath(string);
        return this;
    }

    @Override
    public SimpleRequestBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public SimpleRequestBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public SimpleRequestBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public SimpleRequestBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public SimpleRequestBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public SimpleRequestBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public SimpleRequestBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public SimpleRequestBuilder setCharset(Charset charset) {
        super.setCharset(charset);
        return this;
    }

    public SimpleRequestBuilder addParameter(NameValuePair nameValuePair) {
        super.addParameter(nameValuePair);
        return this;
    }

    public SimpleRequestBuilder addParameter(String string, String string2) {
        super.addParameter(string, string2);
        return this;
    }

    public SimpleRequestBuilder addParameters(NameValuePair ... nameValuePairArray) {
        super.addParameters(nameValuePairArray);
        return this;
    }

    public SimpleRequestBuilder setAbsoluteRequestUri(boolean bl2) {
        super.setAbsoluteRequestUri(bl2);
        return this;
    }

    public SimpleBody getBody() {
        return this.body;
    }

    public SimpleRequestBuilder setBody(SimpleBody simpleBody) {
        this.body = simpleBody;
        return this;
    }

    public SimpleRequestBuilder setBody(String string, ContentType contentType) {
        this.body = SimpleBody.create(string, contentType);
        return this;
    }

    public SimpleRequestBuilder setBody(byte[] byArray, ContentType contentType) {
        this.body = SimpleBody.create(byArray, contentType);
        return this;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public SimpleRequestBuilder setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    @Override
    public SimpleHttpRequest build() {
        Object object;
        String string = this.getPath();
        SimpleBody simpleBody = this.body;
        String string2 = this.getMethod();
        List<NameValuePair> list = this.getParameters();
        if (list != null && !list.isEmpty()) {
            object = this.getCharset();
            if (simpleBody == null && (Method.POST.isSame(string2) || Method.PUT.isSame(string2))) {
                list = WWWFormCodec.format(list, (Charset)(object != null ? object : ContentType.APPLICATION_FORM_URLENCODED.getCharset()));
                simpleBody = SimpleBody.create((String)((Object)list), ContentType.APPLICATION_FORM_URLENCODED);
            } else {
                try {
                    list = new URIBuilder(string).setCharset((Charset)object).addParameters(list).build();
                    string = ((URI)((Object)list)).toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        if (simpleBody != null && Method.TRACE.isSame(string2)) {
            throw new IllegalStateException((Object)((Object)Method.TRACE) + " requests may not include an entity");
        }
        object = new SimpleHttpRequest(string2, this.getScheme(), this.getAuthority(), string);
        ((BasicHttpRequest)object).setVersion(this.getVersion());
        ((HeaderGroup)object).setHeaders(this.getHeaders());
        ((SimpleHttpRequest)object).setBody(simpleBody);
        ((BasicHttpRequest)object).setAbsoluteRequestUri(this.isAbsoluteRequestUri());
        ((ConfigurableHttpRequest)object).setConfig(this.requestConfig);
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ClassicRequestBuilder [method=");
        stringBuilder.append(this.getMethod());
        stringBuilder.append(", scheme=");
        stringBuilder.append(this.getScheme());
        stringBuilder.append(", authority=");
        stringBuilder.append(this.getAuthority());
        stringBuilder.append(", path=");
        stringBuilder.append(this.getPath());
        stringBuilder.append(", parameters=");
        stringBuilder.append(this.getParameters());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append(", body=");
        stringBuilder.append(this.body);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

