/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class AuthChallenge {
    private final ChallengeType challengeType;
    private final String schemeName;
    private final String value;
    private final List<NameValuePair> params;

    public AuthChallenge(ChallengeType challengeType, String string, String string2, List<? extends NameValuePair> list) {
        this.challengeType = Args.notNull(challengeType, "Challenge type");
        this.schemeName = Args.notNull(string, "schemeName");
        this.value = string2;
        this.params = list != null ? Collections.unmodifiableList(new ArrayList<NameValuePair>(list)) : null;
    }

    public AuthChallenge(ChallengeType challengeType, String string, NameValuePair ... nameValuePairArray) {
        this(challengeType, string, null, Arrays.asList(nameValuePairArray));
    }

    public final ChallengeType getChallengeType() {
        return this.challengeType;
    }

    public final String getSchemeName() {
        return this.schemeName;
    }

    public final String getValue() {
        return this.value;
    }

    public final List<NameValuePair> getParams() {
        return this.params;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schemeName).append(" ");
        if (this.value != null) {
            stringBuilder.append(this.value);
        } else if (this.params != null) {
            stringBuilder.append(this.params);
        }
        return stringBuilder.toString();
    }
}

