/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.util.Locale;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class AuthScope {
    private final String protocol;
    private final String host;
    private final int port;
    private final String realm;
    private final String schemeName;

    public AuthScope(String string, String string2, int n2, String string3, String string4) {
        this.protocol = string != null ? string.toLowerCase(Locale.ROOT) : null;
        this.host = string2 != null ? string2.toLowerCase(Locale.ROOT) : null;
        this.port = n2 >= 0 ? n2 : -1;
        this.realm = string3;
        this.schemeName = string4 != null ? string4.toUpperCase(Locale.ROOT) : null;
    }

    public AuthScope(HttpHost httpHost, String string, String string2) {
        Args.notNull(httpHost, "Host");
        this.protocol = httpHost.getSchemeName().toLowerCase(Locale.ROOT);
        this.host = httpHost.getHostName().toLowerCase(Locale.ROOT);
        this.port = httpHost.getPort() >= 0 ? httpHost.getPort() : -1;
        this.realm = string;
        this.schemeName = string2 != null ? string2.toUpperCase(Locale.ROOT) : null;
    }

    public AuthScope(HttpHost httpHost) {
        this(httpHost, null, null);
    }

    public AuthScope(String string, int n2) {
        this(null, string, n2, null, null);
    }

    public AuthScope(AuthScope authScope) {
        Args.notNull(authScope, "Scope");
        this.protocol = authScope.getProtocol();
        this.host = authScope.getHost();
        this.port = authScope.getPort();
        this.realm = authScope.getRealm();
        this.schemeName = authScope.getSchemeName();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public int match(AuthScope authScope) {
        int n2 = 0;
        if (Objects.equals(this.schemeName, authScope.schemeName)) {
            ++n2;
        } else if (this.schemeName != null && authScope.schemeName != null) {
            return -1;
        }
        if (Objects.equals(this.realm, authScope.realm)) {
            n2 += 2;
        } else if (this.realm != null && authScope.realm != null) {
            return -1;
        }
        if (this.port == authScope.port) {
            n2 += 4;
        } else if (this.port != -1 && authScope.port != -1) {
            return -1;
        }
        if (Objects.equals(this.protocol, authScope.protocol)) {
            n2 += 8;
        } else if (this.protocol != null && authScope.protocol != null) {
            return -1;
        }
        if (Objects.equals(this.host, authScope.host)) {
            n2 += 16;
        } else if (this.host != null && authScope.host != null) {
            return -1;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AuthScope) {
            object = (AuthScope)object;
            return Objects.equals(this.protocol, ((AuthScope)object).protocol) && Objects.equals(this.host, ((AuthScope)object).host) && this.port == ((AuthScope)object).port && Objects.equals(this.realm, ((AuthScope)object).realm) && Objects.equals(this.schemeName, ((AuthScope)object).schemeName);
        }
        return false;
    }

    public int hashCode() {
        int n2 = LangUtils.hashCode(17, this.protocol);
        n2 = LangUtils.hashCode(n2, this.host);
        n2 = LangUtils.hashCode(n2, this.port);
        n2 = LangUtils.hashCode(n2, this.realm);
        n2 = LangUtils.hashCode(n2, this.schemeName);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.schemeName != null) {
            stringBuilder.append(this.schemeName);
        } else {
            stringBuilder.append("<any auth scheme>");
        }
        stringBuilder.append(' ');
        if (this.realm != null) {
            stringBuilder.append('\'');
            stringBuilder.append(this.realm);
            stringBuilder.append('\'');
        } else {
            stringBuilder.append("<any realm>");
        }
        stringBuilder.append(' ');
        if (this.protocol != null) {
            stringBuilder.append(this.protocol);
        } else {
            stringBuilder.append("<any protocol>");
        }
        stringBuilder.append("://");
        if (this.host != null) {
            stringBuilder.append(this.host);
        } else {
            stringBuilder.append("<any host>");
        }
        stringBuilder.append(':');
        if (this.port >= 0) {
            stringBuilder.append(this.port);
        } else {
            stringBuilder.append("<any port>");
        }
        return stringBuilder.toString();
    }
}

