/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Locale;
import java.util.Objects;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTUserPrincipal;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NTCredentials
implements Serializable,
Credentials {
    private static final long serialVersionUID = -7385699315228907265L;
    private final NTUserPrincipal principal;
    private final char[] password;
    private final String workstation;
    private final String netbiosDomain;

    public NTCredentials(String string, char[] cArray, String string2, String string3) {
        String string4 = string3;
        this(cArray, string, string4, NTCredentials.convertDomain(string4));
    }

    public NTCredentials(String string, char[] cArray, String string2, String string3, String string4) {
        this(cArray, string, string3, string4);
    }

    public NTCredentials(char[] cArray, String string, String string2, String string3) {
        Args.notNull(string, "User name");
        this.principal = new NTUserPrincipal(string2, string);
        this.password = cArray;
        this.workstation = NTCredentials.getWorkstationName().toUpperCase(Locale.ROOT);
        this.netbiosDomain = string3;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getUsername();
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.principal.getDomain();
    }

    public String getNetbiosDomain() {
        return this.netbiosDomain;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public int hashCode() {
        int n2 = LangUtils.hashCode(17, this.principal);
        n2 = LangUtils.hashCode(n2, this.workstation);
        n2 = LangUtils.hashCode(n2, this.netbiosDomain);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NTCredentials) {
            object = (NTCredentials)object;
            return Objects.equals(this.principal, ((NTCredentials)object).principal) && Objects.equals(this.workstation, ((NTCredentials)object).workstation) && Objects.equals(this.netbiosDomain, ((NTCredentials)object).netbiosDomain);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[principal: ");
        stringBuilder.append(this.principal);
        stringBuilder.append("][workstation: ");
        stringBuilder.append(this.workstation);
        stringBuilder.append("][netbiosDomain: ");
        stringBuilder.append(this.netbiosDomain);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String stripDotSuffix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    private static String convertDomain(String string) {
        if ((string = NTCredentials.stripDotSuffix(string)) == null) {
            return string;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    private static String getWorkstationName() {
        try {
            Object object = InetAddress.getLocalHost();
            object = ((InetAddress)object).getHostName();
            return NTCredentials.stripDotSuffix((String)object);
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }
}

