/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NTUserPrincipal
implements Serializable,
Principal {
    private static final long serialVersionUID = -6870169797924406894L;
    private final String username;
    private final String domain;
    private final String ntname;

    public NTUserPrincipal(String charSequence, String string) {
        Args.notNull(string, "User name");
        this.username = string;
        this.domain = charSequence != null ? ((String)charSequence).toUpperCase(Locale.ROOT) : null;
        if (this.domain != null && !this.domain.isEmpty()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(this.domain);
            ((StringBuilder)charSequence).append('\\');
            ((StringBuilder)charSequence).append(this.username);
            this.ntname = ((StringBuilder)charSequence).toString();
            return;
        }
        this.ntname = this.username;
    }

    @Override
    public String getName() {
        return this.ntname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public int hashCode() {
        int n2 = LangUtils.hashCode(17, this.username);
        n2 = LangUtils.hashCode(n2, this.domain);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NTUserPrincipal) {
            object = (NTUserPrincipal)object;
            return Objects.equals(this.username, ((NTUserPrincipal)object).username) && Objects.equals(this.domain, ((NTUserPrincipal)object).domain);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ntname;
    }
}

