/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Objects;
import org.apache.hc.client5.http.auth.BasicUserPrincipal;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class UsernamePasswordCredentials
implements Serializable,
Credentials {
    private static final long serialVersionUID = 243343858802739403L;
    private final Principal principal;
    private final char[] password;

    public UsernamePasswordCredentials(Principal principal, char[] cArray) {
        this.principal = Args.notNull(principal, "User principal");
        this.password = cArray;
    }

    public UsernamePasswordCredentials(String string, char[] cArray) {
        this(new BasicUserPrincipal(string), cArray);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getName();
    }

    public char[] getUserPassword() {
        return this.password;
    }

    @Override
    @Deprecated
    public char[] getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UsernamePasswordCredentials) {
            object = (UsernamePasswordCredentials)object;
            return Objects.equals(this.principal, ((UsernamePasswordCredentials)object).principal);
        }
        return false;
    }

    public String toString() {
        return this.principal.toString();
    }
}

