/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.config;

import java.util.Arrays;
import org.apache.hc.client5.http.config.TlsConfig$Builder;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class TlsConfig
implements Cloneable {
    public static final TlsConfig DEFAULT = new TlsConfig$Builder().build();
    private final Timeout handshakeTimeout;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final HttpVersionPolicy httpVersionPolicy;

    protected TlsConfig() {
        this(null, null, null, null);
    }

    TlsConfig(Timeout timeout, String[] stringArray, String[] stringArray2, HttpVersionPolicy httpVersionPolicy) {
        this.handshakeTimeout = timeout;
        this.supportedProtocols = stringArray;
        this.supportedCipherSuites = stringArray2;
        this.httpVersionPolicy = httpVersionPolicy;
    }

    public Timeout getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public String[] getSupportedProtocols() {
        if (this.supportedProtocols != null) {
            return (String[])this.supportedProtocols.clone();
        }
        return null;
    }

    public String[] getSupportedCipherSuites() {
        if (this.supportedCipherSuites != null) {
            return (String[])this.supportedCipherSuites.clone();
        }
        return null;
    }

    public HttpVersionPolicy getHttpVersionPolicy() {
        return this.httpVersionPolicy;
    }

    protected TlsConfig clone() throws CloneNotSupportedException {
        return (TlsConfig)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append("handshakeTimeout=").append(this.handshakeTimeout);
        stringBuilder.append(", supportedProtocols=").append(Arrays.toString(this.supportedProtocols));
        stringBuilder.append(", supportedCipherSuites=").append(Arrays.toString(this.supportedCipherSuites));
        stringBuilder.append(", httpVersionPolicy=").append((Object)this.httpVersionPolicy);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static TlsConfig$Builder custom() {
        return new TlsConfig$Builder();
    }

    public static TlsConfig$Builder copy(TlsConfig tlsConfig) {
        return new TlsConfig$Builder().setHandshakeTimeout(tlsConfig.getHandshakeTimeout()).setSupportedProtocols(tlsConfig.getSupportedProtocols()).setSupportedCipherSuites(tlsConfig.getSupportedCipherSuites()).setVersionPolicy(tlsConfig.getHttpVersionPolicy());
    }
}

