/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cookie;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieIdentityComparator;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicCookieStore
implements Serializable,
CookieStore {
    private static final long serialVersionUID = -7581093305228232025L;
    private final TreeSet<Cookie> cookies = new TreeSet<Cookie>(CookieIdentityComparator.INSTANCE);
    private transient ReadWriteLock lock = new ReentrantReadWriteLock();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (cookie != null) {
            this.lock.writeLock().lock();
            try {
                this.cookies.remove(cookie);
                if (!cookie.isExpired(Instant.now())) {
                    this.cookies.add(cookie);
                }
                return;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void addCookies(Cookie[] cookieArray) {
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                this.addCookie(cookie);
            }
        }
    }

    @Override
    public List<Cookie> getCookies() {
        this.lock.readLock().lock();
        try {
            ArrayList<Cookie> arrayList = new ArrayList<Cookie>(this.cookies);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            boolean bl2 = false;
            Iterator<Cookie> iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isExpired(date)) continue;
                iterator.remove();
                bl2 = true;
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean clearExpired(Instant instant) {
        if (instant == null) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            boolean bl2 = false;
            Iterator<Cookie> iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isExpired(instant)) continue;
                iterator.remove();
                bl2 = true;
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cookies.clear();
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.cookies.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

