/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cookie;

import java.util.Locale;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String string, int n2, String string2, boolean bl2) {
        Args.notBlank(string, "Host");
        Args.notNegative(n2, "Port");
        Args.notNull(string2, "Path");
        this.host = string.toLowerCase(Locale.ROOT);
        this.port = n2;
        this.path = !TextUtils.isBlank(string2) ? string2 : "/";
        this.secure = bl2;
    }

    public final String getHost() {
        return this.host;
    }

    public final String getPath() {
        return this.path;
    }

    public final int getPort() {
        return this.port;
    }

    public final boolean isSecure() {
        return this.secure;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.secure) {
            stringBuilder.append("(secure)");
        }
        stringBuilder.append(this.host);
        stringBuilder.append(':');
        stringBuilder.append(this.port);
        stringBuilder.append(this.path);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

