/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

abstract class AbstractMultipartFormat {
    private String preamble;
    private String epilogue;
    static final ByteArrayBuffer FIELD_SEP = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, ": ");
    static final ByteArrayBuffer CR_LF = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, "\r\n");
    static final ByteArrayBuffer TWO_HYPHENS = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, "--");
    final Charset charset;
    final String boundary;

    static ByteArrayBuffer encode(Charset comparable, CharSequence object) {
        comparable = ((Charset)comparable).encode(CharBuffer.wrap((CharSequence)object));
        object = new ByteArrayBuffer(((Buffer)((Object)comparable)).remaining());
        ((ByteArrayBuffer)object).append(((ByteBuffer)comparable).array(), ((ByteBuffer)comparable).arrayOffset() + ((Buffer)((Object)comparable)).position(), ((Buffer)((Object)comparable)).remaining());
        return object;
    }

    static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream) throws IOException {
        outputStream.write(byteArrayBuffer.array(), 0, byteArrayBuffer.length());
    }

    static void writeBytes(CharSequence object, Charset charset, OutputStream outputStream) throws IOException {
        object = AbstractMultipartFormat.encode(charset, (CharSequence)object);
        AbstractMultipartFormat.writeBytes((ByteArrayBuffer)object, outputStream);
    }

    static void writeBytes(CharSequence object, OutputStream outputStream) throws IOException {
        object = AbstractMultipartFormat.encode(StandardCharsets.ISO_8859_1, (CharSequence)object);
        AbstractMultipartFormat.writeBytes((ByteArrayBuffer)object, outputStream);
    }

    static boolean isLineBreak(char c2) {
        return c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\u000b';
    }

    static CharSequence stripLineBreaks(CharSequence charSequence) {
        int n2;
        if (charSequence == null) {
            return null;
        }
        char c2 = '\u0000';
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            char c3 = charSequence.charAt(n2);
            if (!AbstractMultipartFormat.isLineBreak(c3)) continue;
            c2 = '\u0001';
            break;
        }
        if (c2 == '\u0000') {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(charSequence, 0, n2);
        while (n2 < charSequence.length()) {
            c2 = charSequence.charAt(n2);
            if (AbstractMultipartFormat.isLineBreak(c2)) {
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    static void writeField(MimeField mimeField, OutputStream outputStream) throws IOException {
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(mimeField.getName()), outputStream);
        AbstractMultipartFormat.writeBytes(FIELD_SEP, outputStream);
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(mimeField.getBody()), outputStream);
        AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
    }

    static void writeField(MimeField mimeField, Charset charset, OutputStream outputStream) throws IOException {
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(mimeField.getName()), charset, outputStream);
        AbstractMultipartFormat.writeBytes(FIELD_SEP, outputStream);
        AbstractMultipartFormat.writeBytes(AbstractMultipartFormat.stripLineBreaks(mimeField.getBody()), charset, outputStream);
        AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
    }

    public AbstractMultipartFormat(Charset charset, String string) {
        Args.notNull(string, "Multipart boundary");
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        this.boundary = string;
    }

    public AbstractMultipartFormat(Charset charset, String string, String string2, String string3) {
        Args.notNull(string, "Multipart boundary");
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        this.boundary = string;
        this.preamble = string2;
        this.epilogue = string3;
    }

    public AbstractMultipartFormat(String string) {
        this(null, string);
    }

    public abstract List<MultipartPart> getParts();

    void doWriteTo(OutputStream outputStream, boolean bl2) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartFormat.encode(this.charset, this.boundary);
        if (this.preamble != null) {
            AbstractMultipartFormat.writeBytes(this.preamble, outputStream);
            AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
        }
        for (MultipartPart multipartPart : this.getParts()) {
            AbstractMultipartFormat.writeBytes(TWO_HYPHENS, outputStream);
            AbstractMultipartFormat.writeBytes(byteArrayBuffer, outputStream);
            AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
            this.formatMultipartHeader(multipartPart, outputStream);
            AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
            if (bl2) {
                multipartPart.getBody().writeTo(outputStream);
            }
            AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
        }
        AbstractMultipartFormat.writeBytes(TWO_HYPHENS, outputStream);
        AbstractMultipartFormat.writeBytes(byteArrayBuffer, outputStream);
        AbstractMultipartFormat.writeBytes(TWO_HYPHENS, outputStream);
        AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
        if (this.epilogue != null) {
            AbstractMultipartFormat.writeBytes(this.epilogue, outputStream);
            AbstractMultipartFormat.writeBytes(CR_LF, outputStream);
        }
    }

    protected abstract void formatMultipartHeader(MultipartPart var1, OutputStream var2) throws IOException;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.doWriteTo(outputStream, true);
    }

    public long getTotalLength() {
        long l2 = 0L;
        for (MultipartPart multipartPart : this.getParts()) {
            ContentBody object = multipartPart.getBody();
            long l3 = object.getContentLength();
            if (l3 >= 0L) {
                l2 += l3;
                continue;
            }
            return -1L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.doWriteTo(byteArrayOutputStream, false);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return l2 + (long)byArray.length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

