/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.AbstractMultipartFormat;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.PercentCodec;

class HttpRFC7578Multipart
extends AbstractMultipartFormat {
    private final List<MultipartPart> parts;
    private final HttpMultipartMode mode;

    public HttpRFC7578Multipart(Charset charset, String string, List<MultipartPart> list, String string2, String string3, HttpMultipartMode httpMultipartMode) {
        super(charset, string, string2, string3);
        this.parts = list;
        this.mode = httpMultipartMode != null ? httpMultipartMode : HttpMultipartMode.STRICT;
    }

    public HttpRFC7578Multipart(Charset charset, String string, List<MultipartPart> list, HttpMultipartMode httpMultipartMode) {
        this(charset, string, list, null, null, httpMultipartMode);
    }

    @Override
    public List<MultipartPart> getParts() {
        return this.parts;
    }

    @Override
    protected void formatMultipartHeader(MultipartPart object, OutputStream outputStream) throws IOException {
        for (Object object2 : ((MultipartPart)object).getHeader()) {
            if ("Content-Disposition".equalsIgnoreCase(((MimeField)object2).getName())) {
                HttpRFC7578Multipart.writeBytes(((MimeField)object2).getName(), this.charset, outputStream);
                HttpRFC7578Multipart.writeBytes(FIELD_SEP, outputStream);
                HttpRFC7578Multipart.writeBytes(((MimeField)object2).getValue(), outputStream);
                object2 = ((MimeField)object2).getParameters();
                for (int i2 = 0; i2 < object2.size(); ++i2) {
                    Object object3 = (NameValuePair)object2.get(i2);
                    String string = object3.getName();
                    object3 = object3.getValue();
                    HttpRFC7578Multipart.writeBytes("; ", outputStream);
                    HttpRFC7578Multipart.writeBytes(string, outputStream);
                    HttpRFC7578Multipart.writeBytes("=\"", outputStream);
                    if (object3 != null) {
                        if (string.equalsIgnoreCase("filename*")) {
                            object3 = "UTF-8''" + PercentCodec.RFC5987.encode((CharSequence)object3);
                            HttpRFC7578Multipart.writeBytes((CharSequence)object3, StandardCharsets.US_ASCII, outputStream);
                        } else if (string.equalsIgnoreCase("filename")) {
                            if (this.mode == HttpMultipartMode.EXTENDED) {
                                object3 = PercentCodec.RFC5987.encode((CharSequence)object3);
                                HttpRFC7578Multipart.writeBytes((CharSequence)object3, StandardCharsets.US_ASCII, outputStream);
                            } else {
                                HttpRFC7578Multipart.writeBytes((CharSequence)object3, StandardCharsets.ISO_8859_1, outputStream);
                            }
                        } else {
                            HttpRFC7578Multipart.writeBytes((CharSequence)object3, outputStream);
                        }
                    }
                    HttpRFC7578Multipart.writeBytes("\"", outputStream);
                }
                HttpRFC7578Multipart.writeBytes(CR_LF, outputStream);
                continue;
            }
            HttpRFC7578Multipart.writeField((MimeField)object2, this.charset, outputStream);
        }
    }
}

