/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;

public class MimeField {
    private final String name;
    private final String value;
    private final List<NameValuePair> parameters;

    public MimeField(String string, String string2) {
        this.name = string;
        this.value = string2;
        this.parameters = Collections.emptyList();
    }

    public MimeField(String string, String string2, List<NameValuePair> list) {
        this.name = string;
        this.value = string2;
        this.parameters = list != null ? Collections.unmodifiableList(new ArrayList<NameValuePair>(list)) : Collections.emptyList();
    }

    public MimeField(MimeField mimeField) {
        this(mimeField.name, mimeField.value, mimeField.parameters);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getBody() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.value);
        this.parameters.forEach(object -> {
            stringBuilder.append("; ");
            stringBuilder.append(object.getName());
            stringBuilder.append("=\"");
            object = object.getValue();
            for (int i2 = 0; i2 < ((String)object).length(); ++i2) {
                char c2 = ((String)object).charAt(i2);
                if (c2 == '\"' || c2 == '\\') {
                    stringBuilder.append("\\");
                }
                stringBuilder.append(c2);
            }
            stringBuilder.append("\"");
        });
        return stringBuilder.toString();
    }

    public List<NameValuePair> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(": ");
        stringBuilder.append(this.getBody());
        return stringBuilder.toString();
    }
}

