/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    public static final DefaultHttpRequestRetryStrategy INSTANCE = new DefaultHttpRequestRetryStrategy();
    private final int maxRetries;
    private final TimeValue defaultRetryInterval;
    private final Set<Class<? extends IOException>> nonRetriableIOExceptionClasses;
    private final Set<Integer> retriableCodes;

    protected DefaultHttpRequestRetryStrategy(int n2, TimeValue timeValue, Collection<Class<? extends IOException>> collection, Collection<Integer> collection2) {
        Args.notNegative(n2, "maxRetries");
        Args.notNull(timeValue, "defaultRetryInterval");
        Args.check(TimeValue.isNonNegative(timeValue), "Default retry interval is negative");
        this.maxRetries = n2;
        this.defaultRetryInterval = timeValue;
        this.nonRetriableIOExceptionClasses = new HashSet<Class<? extends IOException>>(collection);
        this.retriableCodes = new HashSet<Integer>(collection2);
    }

    public DefaultHttpRequestRetryStrategy(int n2, TimeValue timeValue) {
        this(n2, timeValue, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class), Arrays.asList(429, 503));
    }

    public DefaultHttpRequestRetryStrategy() {
        this(1, TimeValue.ofSeconds(1L));
    }

    @Override
    public boolean retryRequest(HttpRequest httpRequest, IOException iOException, int n2, HttpContext clazz2) {
        Args.notNull(httpRequest, "request");
        Args.notNull(iOException, "exception");
        if (n2 > this.maxRetries) {
            return false;
        }
        if (this.nonRetriableIOExceptionClasses.contains(iOException.getClass())) {
            return false;
        }
        for (Class<? extends IOException> clazz2 : this.nonRetriableIOExceptionClasses) {
            if (!clazz2.isInstance(iOException)) continue;
            return false;
        }
        if (httpRequest instanceof CancellableDependency && ((CancellableDependency)((Object)httpRequest)).isCancelled()) {
            return false;
        }
        return this.handleAsIdempotent(httpRequest);
    }

    @Override
    public boolean retryRequest(HttpResponse httpResponse, int n2, HttpContext object) {
        Args.notNull(httpResponse, "response");
        if (object != null) {
            object = HttpClientContext.cast((HttpContext)object);
            object = ((HttpClientContext)object).getRequestConfigOrDefault();
            if ((object = ((RequestConfig)object).getResponseTimeout()) != null && this.defaultRetryInterval.compareTo((TimeValue)object) > 0) {
                return false;
            }
        }
        return n2 <= this.maxRetries && this.retriableCodes.contains(httpResponse.getCode());
    }

    @Override
    public TimeValue getRetryInterval(HttpResponse object, int n2, HttpContext httpContext) {
        Args.notNull(object, "response");
        object = object.getFirstHeader("Retry-After");
        TimeValue timeValue = null;
        if (object != null) {
            block4: {
                object = object.getValue();
                try {
                    timeValue = TimeValue.ofSeconds(Long.parseLong((String)object));
                }
                catch (NumberFormatException numberFormatException) {
                    object = DateUtils.parseStandardDate((String)object);
                    if (object == null) break block4;
                    timeValue = TimeValue.ofMilliseconds(((Instant)object).toEpochMilli() - System.currentTimeMillis());
                }
            }
            if (TimeValue.isPositive(timeValue)) {
                return timeValue;
            }
        }
        return this.defaultRetryInterval;
    }

    protected boolean handleAsIdempotent(HttpRequest httpRequest) {
        return Method.isIdempotent(httpRequest.getMethod());
    }
}

