/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost httpHost) {
        Args.notNull(httpHost, "HTTP host");
        return this.resolve(httpHost.getSchemeName(), httpHost);
    }

    @Override
    public int resolve(String string, NamedEndpoint namedEndpoint) {
        Args.notNull(namedEndpoint, "Endpoint");
        int n2 = namedEndpoint.getPort();
        if (n2 > 0) {
            return n2;
        }
        if (URIScheme.HTTP.same(string)) {
            return 80;
        }
        if (URIScheme.HTTPS.same(string)) {
            return 443;
        }
        return -1;
    }
}

