/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class IdleConnectionEvictor {
    private final ThreadFactory threadFactory;
    private final Thread thread;

    public IdleConnectionEvictor(ConnPoolControl<?> connPoolControl, ThreadFactory object, TimeValue timeValue, TimeValue timeValue2) {
        Args.notNull(connPoolControl, "Connection manager");
        this.threadFactory = object != null ? object : new DefaultThreadFactory("idle-connection-evictor", true);
        object = timeValue != null ? timeValue : TimeValue.ofSeconds(5L);
        this.thread = this.threadFactory.newThread(() -> IdleConnectionEvictor.lambda$new$0((TimeValue)object, connPoolControl, timeValue2));
    }

    public IdleConnectionEvictor(ConnPoolControl<?> connPoolControl, TimeValue timeValue, TimeValue timeValue2) {
        this(connPoolControl, null, timeValue, timeValue2);
    }

    public IdleConnectionEvictor(ConnPoolControl<?> connPoolControl, TimeValue timeValue) {
        TimeValue timeValue2 = timeValue;
        this(connPoolControl, null, timeValue2, timeValue2);
    }

    public final void start() {
        this.thread.start();
    }

    public final void shutdown() {
        this.thread.interrupt();
    }

    public final boolean isRunning() {
        return this.thread.isAlive();
    }

    public final void awaitTermination(Timeout timeout) throws InterruptedException {
        this.thread.join(timeout != null ? timeout.toMilliseconds() : Long.MAX_VALUE);
    }

    private static /* synthetic */ void lambda$new$0(TimeValue timeValue, ConnPoolControl connPoolControl, TimeValue timeValue2) {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                timeValue.sleep();
                connPoolControl.closeExpired();
                if (timeValue2 == null) continue;
                connPoolControl.closeIdle(timeValue2);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

