/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class InMemoryDnsResolver
implements DnsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDnsResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new ConcurrentHashMap<String, InetAddress[]>();

    public void add(String string, InetAddress ... inetAddressArray) {
        Args.notNull(string, "Host name");
        Args.notNull(inetAddressArray, "Array of IP addresses");
        this.dnsMap.put(string, inetAddressArray);
    }

    @Override
    public InetAddress[] resolve(String string) throws UnknownHostException {
        Object[] objectArray = this.dnsMap.get(string);
        if (LOG.isInfoEnabled()) {
            LOG.info("Resolving {} to {}", (Object)string, (Object)Arrays.deepToString(objectArray));
        }
        if (objectArray == null) {
            throw new UnknownHostException(string);
        }
        return objectArray;
    }

    @Override
    public String resolveCanonicalHostname(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = this.resolve(string);
        if (inetAddressArray.length > 0) {
            return inetAddressArray[0].getCanonicalHostName();
        }
        return string;
    }
}

