/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.nio.ByteBuffer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;

@Internal
public class Wire {
    private static final int MAX_STRING_BUILDER_SIZE = 2048;
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL = new ThreadLocal();
    private final Logger log;
    private final String id;

    private static StringBuilder getStringBuilder() {
        StringBuilder stringBuilder = THREAD_LOCAL.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(2048);
            THREAD_LOCAL.set(stringBuilder);
        }
        Wire.trimToMaxSize(stringBuilder, 2048);
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private static void trimToMaxSize(StringBuilder stringBuilder, int n2) {
        if (stringBuilder != null && stringBuilder.capacity() > n2) {
            stringBuilder.setLength(n2);
            stringBuilder.trimToSize();
        }
    }

    public Wire(Logger logger, String string) {
        this.log = logger;
        this.id = string;
    }

    private void wire(String string, byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = Wire.getStringBuilder();
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2 = byArray[n2 + i2];
            if (by2 == 13) {
                stringBuilder.append("[\\r]");
                continue;
            }
            if (by2 == 10) {
                stringBuilder.append("[\\n]\"");
                stringBuilder.insert(0, "\"");
                stringBuilder.insert(0, string);
                this.log.debug("{} {}", (Object)this.id, (Object)stringBuilder);
                stringBuilder.setLength(0);
                continue;
            }
            if (by2 < 32 || by2 >= 127) {
                stringBuilder.append("[0x");
                stringBuilder.append(Integer.toHexString(by2));
                stringBuilder.append("]");
                continue;
            }
            stringBuilder.append((char)by2);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\"');
            stringBuilder.insert(0, '\"');
            stringBuilder.insert(0, string);
            this.log.debug("{} {}", (Object)this.id, (Object)stringBuilder);
        }
    }

    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] byArray, int n2, int n3) {
        Args.notNull(byArray, "Output");
        this.wire(">> ", byArray, n2, n3);
    }

    public void input(byte[] byArray, int n2, int n3) {
        Args.notNull(byArray, "Input");
        this.wire("<< ", byArray, n2, n3);
    }

    public void output(byte[] byArray) {
        Args.notNull(byArray, "Output");
        this.output(byArray, 0, byArray.length);
    }

    public void input(byte[] byArray) {
        Args.notNull(byArray, "Input");
        this.input(byArray, 0, byArray.length);
    }

    public void output(int n2) {
        this.output(new byte[]{(byte)n2});
    }

    public void input(int n2) {
        this.input(new byte[]{(byte)n2});
    }

    public void output(String string) {
        Args.notNull(string, "Output");
        this.output(string.getBytes());
    }

    public void input(String string) {
        Args.notNull(string, "Input");
        this.input(string.getBytes());
    }

    public void output(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Output");
        if (byteBuffer.hasArray()) {
            this.output(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            return;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        this.output(byArray);
    }

    public void input(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Input");
        if (byteBuffer.hasArray()) {
            this.input(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            return;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        this.input(byArray);
    }
}

