/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.async.AbstractHttpAsyncClientBase$Status;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpAsyncClientBase
extends CloseableHttpAsyncClient
implements ConnectionInitiator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpAsyncClientBase.class);
    private final AsyncPushConsumerRegistry pushConsumerRegistry;
    private final DefaultConnectingIOReactor ioReactor;
    private final ExecutorService executorService;
    private final AtomicReference<AbstractHttpAsyncClientBase$Status> status;

    AbstractHttpAsyncClientBase(DefaultConnectingIOReactor defaultConnectingIOReactor, AsyncPushConsumerRegistry asyncPushConsumerRegistry, ThreadFactory threadFactory) {
        this.ioReactor = defaultConnectingIOReactor;
        this.pushConsumerRegistry = asyncPushConsumerRegistry;
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.status = new AtomicReference<AbstractHttpAsyncClientBase$Status>(AbstractHttpAsyncClientBase$Status.READY);
    }

    @Override
    public final void start() {
        if (this.status.compareAndSet(AbstractHttpAsyncClientBase$Status.READY, AbstractHttpAsyncClientBase$Status.RUNNING)) {
            this.executorService.execute(this.ioReactor::start);
        }
    }

    @Override
    @Deprecated
    public void register(String string, String string2, Supplier<AsyncPushConsumer> supplier) {
        this.pushConsumerRegistry.register(string, string2, supplier);
    }

    boolean isRunning() {
        return this.status.get() == AbstractHttpAsyncClientBase$Status.RUNNING;
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint namedEndpoint, SocketAddress socketAddress, SocketAddress socketAddress2, Timeout timeout, Object object, FutureCallback<IOSession> futureCallback) {
        return this.ioReactor.connect(namedEndpoint, socketAddress, socketAddress2, timeout, object, futureCallback);
    }

    ConnectionInitiator getConnectionInitiator() {
        return this.ioReactor;
    }

    @Override
    public final IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public final void awaitShutdown(TimeValue timeValue) throws InterruptedException {
        this.ioReactor.awaitShutdown(timeValue);
    }

    @Override
    public final void initiateShutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating shutdown");
        }
        this.ioReactor.initiateShutdown();
    }

    void internalClose(CloseMode closeMode) {
    }

    @Override
    public final void close(CloseMode closeMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown {}", (Object)closeMode);
        }
        this.ioReactor.initiateShutdown();
        this.ioReactor.close(closeMode);
        if (closeMode == CloseMode.GRACEFUL) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.executorService.shutdownNow();
        }
        this.internalClose(closeMode);
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }
}

