/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.RouteTracker;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChain$Scope;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$1;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$2;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$3;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$4;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$5;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$6;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec$State;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler;
import org.apache.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRouteDirector;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncConnectExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectExec.class);
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final AuthenticationHandler authenticator;
    private final AuthCacheKeeper authCacheKeeper;
    private final HttpRouteDirector routeDirector;

    public AsyncConnectExec(HttpProcessor httpProcessor, AuthenticationStrategy authenticationStrategy, SchemePortResolver schemePortResolver, boolean bl2) {
        Args.notNull(httpProcessor, "Proxy HTTP processor");
        Args.notNull(authenticationStrategy, "Proxy authentication strategy");
        this.proxyHttpProcessor = httpProcessor;
        this.proxyAuthStrategy = authenticationStrategy;
        this.authenticator = new AuthenticationHandler();
        this.authCacheKeeper = bl2 ? null : new AuthCacheKeeper(schemePortResolver);
        this.routeDirector = BasicRouteDirector.INSTANCE;
    }

    @Override
    public final void execute(HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(asyncExecChain$Scope, "Scope");
        String string = asyncExecChain$Scope.exchangeId;
        HttpRoute httpRoute = asyncExecChain$Scope.route;
        CancellableDependency cancellableDependency = asyncExecChain$Scope.cancellableDependency;
        HttpClientContext httpClientContext = asyncExecChain$Scope.clientContext;
        AsyncExecRuntime asyncExecRuntime = asyncExecChain$Scope.execRuntime;
        AsyncConnectExec$State asyncConnectExec$State = new AsyncConnectExec$State(httpRoute);
        if (!asyncExecRuntime.isEndpointAcquired()) {
            Object object = httpClientContext.getUserToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} acquiring connection with route {}", (Object)string, (Object)httpRoute);
            }
            cancellableDependency.setDependency(asyncExecRuntime.acquireEndpoint(string, httpRoute, object, httpClientContext, new AsyncConnectExec$1(this, asyncExecChain, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecCallback, asyncConnectExec$State)));
            return;
        }
        if (asyncExecRuntime.isEndpointConnected()) {
            this.proceedConnected(httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
            return;
        }
        this.proceedToNextHop(asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
    }

    private void proceedToNextHop(AsyncConnectExec$State asyncConnectExec$State, HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) {
        try {
            this.doProceedToNextHop(asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
            return;
        }
        catch (RuntimeException runtimeException) {
            asyncExecCallback.failed(runtimeException);
            return;
        }
    }

    private void doProceedToNextHop(AsyncConnectExec$State asyncConnectExec$State, HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) {
        RouteTracker routeTracker = asyncConnectExec$State.tracker;
        String string = asyncExecChain$Scope.exchangeId;
        Object object = asyncExecChain$Scope.route;
        AsyncExecRuntime asyncExecRuntime = asyncExecChain$Scope.execRuntime;
        Object object2 = asyncExecChain$Scope.cancellableDependency;
        HttpClientContext httpClientContext = asyncExecChain$Scope.clientContext;
        HttpRoute httpRoute = routeTracker.toRoute();
        int n2 = this.routeDirector.nextStep((RouteInfo)object, httpRoute);
        switch (n2) {
            case 1: {
                object2.setDependency(asyncExecRuntime.connectEndpoint(httpClientContext, new AsyncConnectExec$2(this, routeTracker, (HttpRoute)object, string, asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback)));
                return;
            }
            case 2: {
                object2.setDependency(asyncExecRuntime.connectEndpoint(httpClientContext, new AsyncConnectExec$3(this, (HttpRoute)object, routeTracker, string, asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback)));
                return;
            }
            case 3: {
                object2 = ((HttpRoute)object).getProxyHost();
                object = ((HttpRoute)object).getTargetHost();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} create tunnel", (Object)string);
                }
                this.createTunnel(asyncConnectExec$State, (HttpHost)object2, (HttpHost)object, asyncExecChain$Scope, new AsyncConnectExec$4(this, asyncExecCallback, asyncExecRuntime, string, asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, routeTracker));
                return;
            }
            case 4: {
                asyncExecCallback.failed(new HttpException("Proxy chains are not supported"));
                return;
            }
            case 5: {
                asyncExecRuntime.upgradeTls(httpClientContext, new AsyncConnectExec$5(this, string, routeTracker, (HttpRoute)object, asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback));
                return;
            }
            case -1: {
                asyncExecCallback.failed(new HttpException("Unable to establish route: planned = " + object + "; current = " + httpRoute));
                return;
            }
            case 0: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} route fully established", (Object)string);
                }
                this.proceedConnected(httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
                return;
            }
        }
        throw new IllegalStateException("Unknown step indicator " + n2 + " from RouteDirector.");
    }

    private void createTunnel(AsyncConnectExec$State object, HttpHost httpHost, HttpHost httpHost2, AsyncExecChain$Scope object2, AsyncExecCallback asyncExecCallback) {
        AuthExchange authExchange;
        CancellableDependency cancellableDependency = ((AsyncExecChain$Scope)object2).cancellableDependency;
        HttpClientContext httpClientContext = ((AsyncExecChain$Scope)object2).clientContext;
        AsyncExecRuntime asyncExecRuntime = ((AsyncExecChain$Scope)object2).execRuntime;
        object2 = ((AsyncExecChain$Scope)object2).exchangeId;
        AuthExchange authExchange2 = authExchange = httpHost != null ? httpClientContext.getAuthExchange(httpHost) : new AuthExchange();
        if (this.authCacheKeeper != null) {
            this.authCacheKeeper.loadPreemptively(httpHost, null, authExchange, httpClientContext);
        }
        object = new AsyncConnectExec$6(this, asyncExecCallback, httpHost2, httpClientContext, httpHost, authExchange, (AsyncConnectExec$State)object);
        if (LOG.isDebugEnabled()) {
            cancellableDependency.setDependency(asyncExecRuntime.execute((String)object2, new LoggingAsyncClientExchangeHandler(LOG, (String)object2, (AsyncClientExchangeHandler)object), httpClientContext));
            return;
        }
        cancellableDependency.setDependency(asyncExecRuntime.execute((String)object2, (AsyncClientExchangeHandler)object, httpClientContext));
    }

    private boolean needAuthentication(AuthExchange authExchange, HttpHost httpHost, HttpResponse httpResponse, HttpClientContext httpClientContext) throws AuthenticationException, MalformedChallengeException {
        RequestConfig requestConfig = httpClientContext.getRequestConfigOrDefault();
        if (requestConfig.isAuthenticationEnabled()) {
            boolean bl2 = this.authenticator.isChallenged(httpHost, ChallengeType.PROXY, httpResponse, authExchange, httpClientContext);
            boolean bl3 = this.authenticator.isChallengeExpected(authExchange);
            if (this.authCacheKeeper != null) {
                if (bl2) {
                    this.authCacheKeeper.updateOnChallenge(httpHost, null, authExchange, httpClientContext);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(httpHost, null, authExchange, httpClientContext);
                }
            }
            if (bl2 || bl3) {
                boolean bl4 = this.authenticator.handleResponse(httpHost, ChallengeType.PROXY, httpResponse, this.proxyAuthStrategy, authExchange, httpClientContext);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(httpHost, null, authExchange, httpClientContext);
                }
                return bl4;
            }
        }
        return false;
    }

    private void proceedConnected(HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) {
        Object object = asyncExecChain$Scope.execRuntime;
        HttpClientContext httpClientContext = asyncExecChain$Scope.clientContext;
        if ((object = object.getEndpointInfo()) != null) {
            httpClientContext.setSSLSession(((EndpointInfo)object).getSslSession());
        }
        try {
            asyncExecChain.proceed(httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecCallback);
            return;
        }
        catch (IOException | HttpException exception) {
            asyncExecCallback.failed(exception);
            return;
        }
    }

    static /* synthetic */ void access$000(AsyncConnectExec asyncConnectExec, AsyncConnectExec$State asyncConnectExec$State, HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) {
        asyncConnectExec.proceedToNextHop(asyncConnectExec$State, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ HttpProcessor access$200(AsyncConnectExec asyncConnectExec) {
        return asyncConnectExec.proxyHttpProcessor;
    }

    static /* synthetic */ AuthenticationHandler access$300(AsyncConnectExec asyncConnectExec) {
        return asyncConnectExec.authenticator;
    }

    static /* synthetic */ boolean access$400(AsyncConnectExec asyncConnectExec, AuthExchange authExchange, HttpHost httpHost, HttpResponse httpResponse, HttpClientContext httpClientContext) throws AuthenticationException, MalformedChallengeException {
        return asyncConnectExec.needAuthentication(authExchange, httpHost, httpResponse, httpClientContext);
    }
}

