/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

class AsyncPushConsumerRegistry {
    private final UriPatternMatcher<Supplier<AsyncPushConsumer>> primary = new UriPatternMatcher();
    private final ConcurrentMap<String, UriPatternMatcher<Supplier<AsyncPushConsumer>>> hostMap = new ConcurrentHashMap<String, UriPatternMatcher<Supplier<AsyncPushConsumer>>>();

    private UriPatternMatcher<Supplier<AsyncPushConsumer>> getPatternMatcher(String object) {
        if (object == null) {
            return this.primary;
        }
        if ((object = (UriPatternMatcher)this.hostMap.get(object)) != null) {
            return object;
        }
        return this.primary;
    }

    public AsyncPushConsumer get(HttpRequest object) {
        Args.notNull(object, "Request");
        Object object2 = object.getAuthority();
        object2 = object2 != null ? ((URIAuthority)object2).getHostName().toLowerCase(Locale.ROOT) : null;
        object2 = this.getPatternMatcher((String)object2);
        if (object2 == null) {
            return null;
        }
        int n2 = ((String)(object = object.getPath())).indexOf(63);
        if (n2 != -1) {
            object = ((String)object).substring(0, n2);
        }
        if ((object = (Supplier)((UriPatternMatcher)object2).lookup((String)object)) != null) {
            return (AsyncPushConsumer)object.get();
        }
        return null;
    }

    public void register(String string, String string2, Supplier<AsyncPushConsumer> supplier) {
        UriPatternMatcher uriPatternMatcher;
        Args.notBlank(string2, "URI pattern");
        Args.notNull(supplier, "Supplier");
        if (string == null) {
            this.primary.register(string2, supplier);
            return;
        }
        UriPatternMatcher<Supplier<AsyncPushConsumer>> uriPatternMatcher2 = (UriPatternMatcher<Supplier<AsyncPushConsumer>>)this.hostMap.get(string = string.toLowerCase(Locale.ROOT));
        if (uriPatternMatcher2 == null && (uriPatternMatcher2 = this.hostMap.putIfAbsent(string, uriPatternMatcher = new UriPatternMatcher())) == null) {
            uriPatternMatcher2 = uriPatternMatcher;
        }
        uriPatternMatcher2.register(string2, supplier);
    }
}

