/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.STATELESS)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
ModalCloseable {
    public abstract void start();

    public abstract IOReactorStatus getStatus();

    public abstract void awaitShutdown(TimeValue var1) throws InterruptedException;

    public abstract void initiateShutdown();

    protected abstract <T> Future<T> doExecute(HttpHost var1, AsyncRequestProducer var2, AsyncResponseConsumer<T> var3, HandlerFactory<AsyncPushConsumer> var4, HttpContext var5, FutureCallback<T> var6);

    public final <T> Future<T> execute(HttpHost httpHost, AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext, FutureCallback<T> futureCallback) {
        Args.notNull(asyncRequestProducer, "Request producer");
        Args.notNull(asyncResponseConsumer, "Response consumer");
        return this.doExecute(httpHost, asyncRequestProducer, asyncResponseConsumer, handlerFactory, httpContext, futureCallback);
    }

    @Override
    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext, FutureCallback<T> futureCallback) {
        Args.notNull(asyncRequestProducer, "Request producer");
        Args.notNull(asyncResponseConsumer, "Response consumer");
        return this.doExecute(null, asyncRequestProducer, asyncResponseConsumer, handlerFactory, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HttpContext httpContext, FutureCallback<T> futureCallback) {
        Args.notNull(asyncRequestProducer, "Request producer");
        Args.notNull(asyncResponseConsumer, "Response consumer");
        return this.execute(asyncRequestProducer, asyncResponseConsumer, null, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, FutureCallback<T> futureCallback) {
        Args.notNull(asyncRequestProducer, "Request producer");
        Args.notNull(asyncResponseConsumer, "Response consumer");
        return this.execute(asyncRequestProducer, asyncResponseConsumer, null, futureCallback);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest simpleHttpRequest, HttpContext httpContext, FutureCallback<SimpleHttpResponse> futureCallback) {
        Args.notNull(simpleHttpRequest, "Request");
        return this.execute(SimpleRequestProducer.create(simpleHttpRequest), SimpleResponseConsumer.create(), httpContext, futureCallback);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest simpleHttpRequest, FutureCallback<SimpleHttpResponse> futureCallback) {
        return this.execute(simpleHttpRequest, null, futureCallback);
    }

    @Deprecated
    public abstract void register(String var1, String var2, Supplier<AsyncPushConsumer> var3);

    @Deprecated
    public final void register(String string, Supplier<AsyncPushConsumer> supplier) {
        this.register(null, string, supplier);
    }
}

