/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import org.apache.hc.client5.http.impl.async.H2AsyncClientProtocolStarter$1;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class H2AsyncClientProtocolStarter
implements IOEventHandlerFactory {
    private static final Logger HEADER_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http.headers");
    private static final Logger FRAME_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http2.frame");
    private static final Logger FRAME_PAYLOAD_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http2.frame.payload");
    private static final Logger FLOW_CTRL_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http2.flow");
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncPushConsumer> exchangeHandlerFactory;
    private final H2Config h2Config;
    private final CharCodingConfig charCodingConfig;
    private final Callback<Exception> exceptionCallback;

    H2AsyncClientProtocolStarter(HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> handlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig, Callback<Exception> callback) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.exchangeHandlerFactory = handlerFactory;
        this.h2Config = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.exceptionCallback = callback;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession protocolIOSession, Object object) {
        if (HEADER_LOG.isDebugEnabled() || FRAME_LOG.isDebugEnabled() || FRAME_PAYLOAD_LOG.isDebugEnabled() || FLOW_CTRL_LOG.isDebugEnabled()) {
            object = protocolIOSession.getId();
            object = new ClientH2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, new H2AsyncClientProtocolStarter$1(this, (String)object));
            return new ClientH2PrefaceHandler(protocolIOSession, (ClientH2StreamMultiplexerFactory)object, false, this.exceptionCallback);
        }
        object = new ClientH2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, null);
        return new ClientH2PrefaceHandler(protocolIOSession, (ClientH2StreamMultiplexerFactory)object, false, this.exceptionCallback);
    }

    static /* synthetic */ Logger access$000() {
        return FRAME_LOG;
    }

    static /* synthetic */ Logger access$100() {
        return FRAME_PAYLOAD_LOG;
    }

    static /* synthetic */ Logger access$200() {
        return FLOW_CTRL_LOG;
    }

    static /* synthetic */ Logger access$300() {
        return HEADER_LOG;
    }
}

