/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientProtocolNegotiationStarter$1;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientProtocolNegotiationStarter$2;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientProtocolNegotiationStarter$3;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncClient;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientH2UpgradeHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp1UpgradeHandler;
import org.apache.hc.core5.http2.impl.nio.HttpProtocolNegotiator;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpAsyncClientProtocolNegotiationStarter
implements IOEventHandlerFactory {
    private static final Logger STREAM_LOG = LoggerFactory.getLogger(InternalHttpAsyncClient.class);
    private static final Logger HEADER_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http.headers");
    private static final Logger FRAME_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http2.frame");
    private static final Logger FRAME_PAYLOAD_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http2.frame.payload");
    private static final Logger FLOW_CTRL_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http2.flow");
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncPushConsumer> exchangeHandlerFactory;
    private final H2Config h2Config;
    private final Http1Config h1Config;
    private final CharCodingConfig charCodingConfig;
    private final ConnectionReuseStrategy http1ConnectionReuseStrategy;
    private final NHttpMessageParserFactory<HttpResponse> http1ResponseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> http1RequestWriterFactory;
    private final Callback<Exception> exceptionCallback;

    HttpAsyncClientProtocolNegotiationStarter(HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> handlerFactory, H2Config h2Config, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, Callback<Exception> callback) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.exchangeHandlerFactory = handlerFactory;
        this.h2Config = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.h1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.http1ConnectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultClientConnectionReuseStrategy.INSTANCE;
        this.http1ResponseParserFactory = new DefaultHttpResponseParserFactory(http1Config);
        this.http1RequestWriterFactory = DefaultHttpRequestWriterFactory.INSTANCE;
        this.exceptionCallback = callback;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession protocolIOSession, Object object) {
        ClientH2StreamMultiplexerFactory clientH2StreamMultiplexerFactory;
        ClientHttp1StreamDuplexerFactory clientHttp1StreamDuplexerFactory;
        Object object2;
        if (STREAM_LOG.isDebugEnabled() || HEADER_LOG.isDebugEnabled() || FRAME_LOG.isDebugEnabled() || FRAME_PAYLOAD_LOG.isDebugEnabled() || FLOW_CTRL_LOG.isDebugEnabled()) {
            object2 = protocolIOSession.getId();
            clientHttp1StreamDuplexerFactory = new ClientHttp1StreamDuplexerFactory(this.httpProcessor, this.h1Config, this.charCodingConfig, this.http1ConnectionReuseStrategy, this.http1ResponseParserFactory, this.http1RequestWriterFactory, new HttpAsyncClientProtocolNegotiationStarter$1(this, (String)object2));
            clientH2StreamMultiplexerFactory = new ClientH2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, new HttpAsyncClientProtocolNegotiationStarter$2(this, (String)object2));
        } else {
            clientHttp1StreamDuplexerFactory = new ClientHttp1StreamDuplexerFactory(this.httpProcessor, this.h1Config, this.charCodingConfig, this.http1ConnectionReuseStrategy, this.http1ResponseParserFactory, this.http1RequestWriterFactory, null);
            clientH2StreamMultiplexerFactory = new ClientH2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, null);
        }
        protocolIOSession.registerProtocol(ApplicationProtocol.HTTP_1_1.id, new ClientHttp1UpgradeHandler(clientHttp1StreamDuplexerFactory));
        protocolIOSession.registerProtocol(ApplicationProtocol.HTTP_2.id, new ClientH2UpgradeHandler(clientH2StreamMultiplexerFactory, this.exceptionCallback));
        object2 = object instanceof HttpVersionPolicy ? (HttpVersionPolicy)((Object)object) : HttpVersionPolicy.NEGOTIATE;
        switch (HttpAsyncClientProtocolNegotiationStarter$3.$SwitchMap$org$apache$hc$core5$http2$HttpVersionPolicy[((Enum)object2).ordinal()]) {
            case 1: {
                return new ClientH2PrefaceHandler(protocolIOSession, clientH2StreamMultiplexerFactory, false, this.exceptionCallback);
            }
            case 2: {
                return new ClientHttp1IOEventHandler(clientHttp1StreamDuplexerFactory.create(protocolIOSession));
            }
        }
        return new HttpProtocolNegotiator(protocolIOSession, null);
    }

    static /* synthetic */ Logger access$000() {
        return HEADER_LOG;
    }

    static /* synthetic */ Logger access$100() {
        return STREAM_LOG;
    }

    static /* synthetic */ Logger access$200() {
        return FRAME_LOG;
    }

    static /* synthetic */ Logger access$300() {
        return FRAME_PAYLOAD_LOG;
    }

    static /* synthetic */ Logger access$400() {
        return FLOW_CTRL_LOG;
    }
}

