/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalH2AsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalH2AsyncClient.class);
    private final HttpRoutePlanner routePlanner;
    private final InternalH2ConnPool connPool;

    InternalH2AsyncClient(DefaultConnectingIOReactor defaultConnectingIOReactor, AsyncExecChainElement asyncExecChainElement, AsyncPushConsumerRegistry asyncPushConsumerRegistry, ThreadFactory threadFactory, InternalH2ConnPool internalH2ConnPool, HttpRoutePlanner httpRoutePlanner, Lookup<CookieSpecFactory> lookup, Lookup<AuthSchemeFactory> lookup2, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig requestConfig, List<Closeable> list) {
        super(defaultConnectingIOReactor, asyncPushConsumerRegistry, threadFactory, asyncExecChainElement, lookup, lookup2, cookieStore, credentialsProvider, HttpClientContext::castOrCreate, requestConfig, list);
        this.connPool = internalH2ConnPool;
        this.routePlanner = httpRoutePlanner;
    }

    @Override
    final AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> handlerFactory) {
        return new InternalH2AsyncExecRuntime(LOG, this.connPool, handlerFactory);
    }

    @Override
    final HttpRoute determineRoute(HttpHost object, HttpRequest httpRequest, HttpClientContext httpClientContext) throws HttpException {
        if (((HttpRoute)(object = this.routePlanner.determineRoute((HttpHost)object, httpRequest, httpClientContext))).isTunnelled()) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return object;
    }
}

