/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime$1;
import org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime$2;
import org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime$3;
import org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime$Endpoint;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexCancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class InternalH2AsyncExecRuntime
implements AsyncExecRuntime {
    private final Logger log;
    private final InternalH2ConnPool connPool;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    private final AtomicReference<InternalH2AsyncExecRuntime$Endpoint> sessionRef;
    private volatile boolean reusable;

    InternalH2AsyncExecRuntime(Logger logger, InternalH2ConnPool internalH2ConnPool, HandlerFactory<AsyncPushConsumer> handlerFactory) {
        this.log = logger;
        this.connPool = internalH2ConnPool;
        this.pushHandlerFactory = handlerFactory;
        this.sessionRef = new AtomicReference();
    }

    @Override
    public boolean isEndpointAcquired() {
        return this.sessionRef.get() != null;
    }

    @Override
    public Cancellable acquireEndpoint(String string, HttpRoute httpRoute, Object object, HttpClientContext httpClientContext, FutureCallback<AsyncExecRuntime> futureCallback) {
        if (this.sessionRef.get() == null) {
            object = httpClientContext.getRequestConfigOrDefault();
            object = ((RequestConfig)object).getConnectTimeout();
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} acquiring endpoint ({})", (Object)string, object);
            }
            return Operations.cancellable(this.connPool.getSession(httpRoute, (Timeout)object, new InternalH2AsyncExecRuntime$1(this, httpRoute, string, futureCallback)));
        }
        futureCallback.completed(this);
        return Operations.nonCancellable();
    }

    private void closeEndpoint(InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint) {
        internalH2AsyncExecRuntime$Endpoint.session.close(CloseMode.GRACEFUL);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} endpoint closed", (Object)ConnPoolSupport.getId(internalH2AsyncExecRuntime$Endpoint));
        }
    }

    @Override
    public void releaseEndpoint() {
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.getAndSet(null);
        if (internalH2AsyncExecRuntime$Endpoint != null && !this.reusable) {
            this.closeEndpoint(internalH2AsyncExecRuntime$Endpoint);
        }
    }

    @Override
    public void discardEndpoint() {
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.getAndSet(null);
        if (internalH2AsyncExecRuntime$Endpoint != null) {
            this.closeEndpoint(internalH2AsyncExecRuntime$Endpoint);
        }
    }

    @Override
    public boolean validateConnection() {
        if (this.reusable) {
            InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.get();
            return internalH2AsyncExecRuntime$Endpoint != null && internalH2AsyncExecRuntime$Endpoint.session.isOpen();
        }
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.getAndSet(null);
        if (internalH2AsyncExecRuntime$Endpoint != null) {
            this.closeEndpoint(internalH2AsyncExecRuntime$Endpoint);
        }
        return false;
    }

    @Override
    public boolean isEndpointConnected() {
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.get();
        return internalH2AsyncExecRuntime$Endpoint != null && internalH2AsyncExecRuntime$Endpoint.session.isOpen();
    }

    InternalH2AsyncExecRuntime$Endpoint ensureValid() {
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.get();
        if (internalH2AsyncExecRuntime$Endpoint == null) {
            throw new IllegalStateException("I/O session not acquired / already released");
        }
        return internalH2AsyncExecRuntime$Endpoint;
    }

    @Override
    public Cancellable connectEndpoint(HttpClientContext object, FutureCallback<AsyncExecRuntime> futureCallback) {
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.ensureValid();
        if (internalH2AsyncExecRuntime$Endpoint.session.isOpen()) {
            futureCallback.completed(this);
            return Operations.nonCancellable();
        }
        HttpRoute httpRoute = internalH2AsyncExecRuntime$Endpoint.route;
        object = ((HttpClientContext)object).getRequestConfigOrDefault();
        object = ((RequestConfig)object).getConnectTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} connecting endpoint ({})", (Object)ConnPoolSupport.getId(internalH2AsyncExecRuntime$Endpoint), object);
        }
        return Operations.cancellable(this.connPool.getSession(httpRoute, (Timeout)object, new InternalH2AsyncExecRuntime$2(this, httpRoute, internalH2AsyncExecRuntime$Endpoint, futureCallback)));
    }

    @Override
    public void disconnectEndpoint() {
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.sessionRef.get();
        if (internalH2AsyncExecRuntime$Endpoint != null) {
            internalH2AsyncExecRuntime$Endpoint.session.close(CloseMode.GRACEFUL);
        }
    }

    @Override
    public void upgradeTls(HttpClientContext httpClientContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void upgradeTls(HttpClientContext httpClientContext, FutureCallback<AsyncExecRuntime> futureCallback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EndpointInfo getEndpointInfo() {
        Object object = this.sessionRef.get();
        if (object != null && ((InternalH2AsyncExecRuntime$Endpoint)object).session.isOpen() && ((InternalH2AsyncExecRuntime$Endpoint)object).session instanceof TransportSecurityLayer) {
            object = ((TransportSecurityLayer)((Object)((InternalH2AsyncExecRuntime$Endpoint)object).session)).getTlsDetails();
            return new EndpointInfo(HttpVersion.HTTP_2, object != null ? ((TlsDetails)object).getSSLSession() : null);
        }
        return null;
    }

    @Override
    public Cancellable execute(String string, AsyncClientExchangeHandler asyncClientExchangeHandler, HttpClientContext httpClientContext) {
        ComplexCancellable complexCancellable = new ComplexCancellable();
        InternalH2AsyncExecRuntime$Endpoint internalH2AsyncExecRuntime$Endpoint = this.ensureValid();
        IOSession iOSession = internalH2AsyncExecRuntime$Endpoint.session;
        if (iOSession.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(internalH2AsyncExecRuntime$Endpoint), (Object)string);
            }
            httpClientContext.setProtocolVersion(HttpVersion.HTTP_2);
            iOSession.enqueue(new RequestExecutionCommand(asyncClientExchangeHandler, this.pushHandlerFactory, complexCancellable, httpClientContext), Command$Priority.NORMAL);
        } else {
            HttpRoute httpRoute = internalH2AsyncExecRuntime$Endpoint.route;
            Object object = httpClientContext.getRequestConfigOrDefault();
            object = ((RequestConfig)object).getConnectTimeout();
            this.connPool.getSession(httpRoute, (Timeout)object, new InternalH2AsyncExecRuntime$3(this, httpRoute, internalH2AsyncExecRuntime$Endpoint, string, httpClientContext, iOSession, asyncClientExchangeHandler, complexCancellable));
        }
        return complexCancellable;
    }

    @Override
    public void markConnectionReusable(Object object, TimeValue timeValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    @Override
    public AsyncExecRuntime fork() {
        return new InternalH2AsyncExecRuntime(this.log, this.connPool, this.pushHandlerFactory);
    }

    static /* synthetic */ AtomicReference access$000(InternalH2AsyncExecRuntime internalH2AsyncExecRuntime) {
        return internalH2AsyncExecRuntime.sessionRef;
    }

    static /* synthetic */ boolean access$102(InternalH2AsyncExecRuntime internalH2AsyncExecRuntime, boolean bl2) {
        internalH2AsyncExecRuntime.reusable = bl2;
        return internalH2AsyncExecRuntime.reusable;
    }

    static /* synthetic */ Logger access$200(InternalH2AsyncExecRuntime internalH2AsyncExecRuntime) {
        return internalH2AsyncExecRuntime.log;
    }

    static /* synthetic */ HandlerFactory access$300(InternalH2AsyncExecRuntime internalH2AsyncExecRuntime) {
        return internalH2AsyncExecRuntime.pushHandlerFactory;
    }
}

