/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.slf4j.Logger;

final class LogAppendable
implements Appendable {
    private final Logger log;
    private final String prefix;
    private final StringBuilder buffer;

    public LogAppendable(Logger logger, String string) {
        this.log = logger;
        this.prefix = string;
        this.buffer = new StringBuilder();
    }

    @Override
    public final Appendable append(CharSequence charSequence) throws IOException {
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public final Appendable append(CharSequence charSequence, int n2, int n3) throws IOException {
        while (n2 < n3) {
            this.append(charSequence.charAt(n2));
            ++n2;
        }
        return this;
    }

    @Override
    public final Appendable append(char c2) throws IOException {
        if (c2 == '\n') {
            this.log.debug("{} {}", (Object)this.prefix, (Object)this.buffer);
            this.buffer.setLength(0);
        } else if (c2 != '\r') {
            this.buffer.append(c2);
        }
        return this;
    }

    public final void flush() {
        if (this.buffer.length() > 0) {
            this.log.debug("{} {}", (Object)this.prefix, (Object)this.buffer);
            this.buffer.setLength(0);
        }
    }
}

