/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler$1;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Identifiable;
import org.slf4j.Logger;

final class LoggingAsyncClientExchangeHandler
implements AsyncClientExchangeHandler,
Identifiable {
    private final Logger log;
    private final String exchangeId;
    private final AsyncClientExchangeHandler handler;

    LoggingAsyncClientExchangeHandler(Logger logger, String string, AsyncClientExchangeHandler asyncClientExchangeHandler) {
        this.log = logger;
        this.exchangeId = string;
        this.handler = asyncClientExchangeHandler;
    }

    @Override
    public final String getId() {
        return this.exchangeId;
    }

    @Override
    public final void releaseResources() {
        this.handler.releaseResources();
    }

    @Override
    public final void produceRequest(RequestChannel requestChannel, HttpContext httpContext2) throws HttpException, IOException {
        this.handler.produceRequest((httpRequest, entityDetails, httpContext) -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} send request {} {}, {}", this.exchangeId, httpRequest.getMethod(), httpRequest.getRequestUri(), entityDetails != null ? "entity len " + entityDetails.getContentLength() : "null entity");
            }
            requestChannel.sendRequest(httpRequest, entityDetails, httpContext);
        }, httpContext2);
    }

    @Override
    public final int available() {
        return this.handler.available();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: produce request data", (Object)this.exchangeId);
        }
        this.handler.produce(new LoggingAsyncClientExchangeHandler$1(this, dataStreamChannel));
    }

    @Override
    public final void consumeInformation(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: information response {}", (Object)this.exchangeId, (Object)httpResponse.getCode());
        }
        this.handler.consumeInformation(httpResponse, httpContext);
    }

    @Override
    public final void consumeResponse(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: consume response {}, {}", this.exchangeId, httpResponse.getCode(), entityDetails != null ? "entity len " + entityDetails.getContentLength() : " null entity");
        }
        this.handler.consumeResponse(httpResponse, entityDetails, httpContext);
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.handler.updateCapacity(n2 -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} capacity update {}", (Object)this.exchangeId, (Object)n2);
            }
            capacityChannel.update(n2);
        });
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: consume response data, len {} bytes", (Object)this.exchangeId, (Object)byteBuffer.remaining());
        }
        this.handler.consume(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: end of response data", (Object)this.exchangeId);
        }
        this.handler.streamEnd(list);
    }

    @Override
    public final void failed(Exception exception) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: execution failed: {}", (Object)this.exchangeId, (Object)exception.getMessage());
        }
        this.handler.failed(exception);
    }

    @Override
    public final void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: execution cancelled", (Object)this.exchangeId);
        }
        this.handler.cancel();
    }

    static /* synthetic */ Logger access$000(LoggingAsyncClientExchangeHandler loggingAsyncClientExchangeHandler) {
        return loggingAsyncClientExchangeHandler.log;
    }

    static /* synthetic */ String access$100(LoggingAsyncClientExchangeHandler loggingAsyncClientExchangeHandler) {
        return loggingAsyncClientExchangeHandler.exchangeId;
    }
}

