/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.locks.Lock;
import org.apache.hc.client5.http.impl.async.LoggingIOSession$1;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class LoggingIOSession
implements IOSession {
    private final Logger log;
    private final Logger wireLog;
    private final IOSession session;

    public LoggingIOSession(IOSession iOSession, Logger logger, Logger logger2) {
        this.session = iOSession;
        this.log = logger;
        this.wireLog = logger2;
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public Lock getLock() {
        return this.session.getLock();
    }

    @Override
    public boolean hasCommands() {
        return this.session.hasCommands();
    }

    @Override
    public Command poll() {
        return this.session.poll();
    }

    @Override
    public void enqueue(Command command, Command$Priority command$Priority) {
        this.session.enqueue(command, command$Priority);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Enqueued {} with priority {}", new Object[]{this.session, command.getClass().getSimpleName(), command$Priority});
        }
    }

    @Override
    public ByteChannel channel() {
        return this.session.channel();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int n2) {
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append('[');
        if ((n2 & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n2 & 4) > 0) {
            stringBuilder.append('w');
        }
        if ((n2 & 0x10) > 0) {
            stringBuilder.append('a');
        }
        if ((n2 & 8) > 0) {
            stringBuilder.append('c');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void setEventMask(int n2) {
        this.session.setEventMask(n2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Event mask set {}", (Object)this.session, (Object)LoggingIOSession.formatOps(n2));
        }
    }

    @Override
    public void setEvent(int n2) {
        this.session.setEvent(n2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Event set {}", (Object)this.session, (Object)LoggingIOSession.formatOps(n2));
        }
    }

    @Override
    public void clearEvent(int n2) {
        this.session.clearEvent(n2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Event cleared {}", (Object)this.session, (Object)LoggingIOSession.formatOps(n2));
        }
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Close", (Object)this.session);
        }
        this.session.close();
    }

    @Override
    public IOSession.Status getStatus() {
        return this.session.getStatus();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Close {}", (Object)this.session, (Object)closeMode);
        }
        this.session.close(closeMode);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Set timeout {}", (Object)this.session, (Object)timeout);
        }
        this.session.setSocketTimeout(timeout);
    }

    @Override
    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    @Override
    public void updateReadTime() {
        this.session.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.session.updateWriteTime();
    }

    @Override
    public long getLastEventTime() {
        return this.session.getLastEventTime();
    }

    @Override
    public IOEventHandler getHandler() {
        return this.session.getHandler();
    }

    @Override
    public void upgrade(IOEventHandler iOEventHandler) {
        Args.notNull(iOEventHandler, "Protocol handler");
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} protocol upgrade {}", (Object)this.session, (Object)iOEventHandler.getClass());
        }
        this.session.upgrade(new LoggingIOSession$1(this, iOEventHandler));
    }

    private void logData(ByteBuffer byteBuffer, String string) {
        byte[] byArray = new byte[16];
        StringBuilder stringBuilder = new StringBuilder();
        while (byteBuffer.hasRemaining()) {
            int n2;
            stringBuilder.setLength(0);
            stringBuilder.append(this.session).append(" ").append(string);
            int n3 = Math.min(byteBuffer.remaining(), byArray.length);
            byteBuffer.get(byArray, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                char c2 = (char)byArray[n2];
                if (c2 > ' ' && c2 <= '\u007f') {
                    stringBuilder.append(c2);
                    continue;
                }
                if (Character.isWhitespace(c2)) {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append('.');
            }
            for (n2 = n3; n2 < 17; ++n2) {
                stringBuilder.append(' ');
            }
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuilder.append(' ');
                int n4 = byArray[n2] & 0xFF;
                String string2 = Integer.toHexString(n4);
                if (string2.length() == 1) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(string2);
            }
            this.wireLog.debug(stringBuilder.toString());
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.session.read(byteBuffer);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} {} bytes read", (Object)this.session, (Object)n2);
        }
        if (n2 > 0 && this.wireLog.isDebugEnabled()) {
            byteBuffer = byteBuffer.duplicate();
            int n3 = byteBuffer.position();
            byteBuffer.limit(n3);
            byteBuffer.position(n3 - n2);
            this.logData(byteBuffer, "<< ");
        }
        return n2;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.session.write(byteBuffer);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} {} bytes written", (Object)this.session, (Object)n2);
        }
        if (n2 > 0 && this.wireLog.isDebugEnabled()) {
            byteBuffer = byteBuffer.duplicate();
            int n3 = byteBuffer.position();
            byteBuffer.limit(n3);
            byteBuffer.position(n3 - n2);
            this.logData(byteBuffer, ">> ");
        }
        return n2;
    }

    public String toString() {
        return this.session.toString();
    }

    static /* synthetic */ Logger access$000(LoggingIOSession loggingIOSession) {
        return loggingIOSession.wireLog;
    }

    static /* synthetic */ void access$100(LoggingIOSession loggingIOSession, ByteBuffer byteBuffer, String string) {
        loggingIOSession.logData(byteBuffer, string);
    }
}

