/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class MinimalHttpAsyncClient$InternalAsyncClientEndpoint
extends AsyncClientEndpoint {
    private final AsyncConnectionEndpoint connectionEndpoint;
    private final AtomicBoolean released;
    final /* synthetic */ MinimalHttpAsyncClient this$0;

    MinimalHttpAsyncClient$InternalAsyncClientEndpoint(MinimalHttpAsyncClient minimalHttpAsyncClient, AsyncConnectionEndpoint asyncConnectionEndpoint) {
        this.this$0 = minimalHttpAsyncClient;
        this.connectionEndpoint = asyncConnectionEndpoint;
        this.released = new AtomicBoolean(false);
    }

    boolean isReleased() {
        return this.released.get();
    }

    @Override
    public boolean isConnected() {
        return !this.isReleased() && this.connectionEndpoint.isConnected();
    }

    @Override
    public void execute(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext) {
        Asserts.check(!this.released.get(), "Endpoint has already been released");
        httpContext = HttpClientContext.castOrCreate(httpContext);
        String string = ExecSupport.getNextExchangeId();
        ((HttpClientContext)httpContext).setExchangeId(string);
        if (MinimalHttpAsyncClient.access$200().isDebugEnabled()) {
            MinimalHttpAsyncClient.access$200().debug("{} executing message exchange {}", (Object)string, (Object)ConnPoolSupport.getId(this.connectionEndpoint));
            this.connectionEndpoint.execute(string, new LoggingAsyncClientExchangeHandler(MinimalHttpAsyncClient.access$200(), string, asyncClientExchangeHandler), handlerFactory, httpContext);
            return;
        }
        this.connectionEndpoint.execute(string, asyncClientExchangeHandler, httpContext);
    }

    public void setSocketTimeout(Timeout timeout) {
        this.connectionEndpoint.setSocketTimeout(timeout);
    }

    @Override
    public void releaseAndReuse() {
        if (this.released.compareAndSet(false, true)) {
            MinimalHttpAsyncClient.access$100(this.this$0).release(this.connectionEndpoint, null, TimeValue.NEG_ONE_MILLISECOND);
        }
    }

    @Override
    public void releaseAndDiscard() {
        if (this.released.compareAndSet(false, true)) {
            Closer.closeQuietly(this.connectionEndpoint);
            MinimalHttpAsyncClient.access$100(this.this$0).release(this.connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
        }
    }
}

