/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthExchange$State;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler$1;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public class AuthenticationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationHandler.class);
    private final AuthChallengeParser parser = new AuthChallengeParser();

    public boolean isChallenged(HttpHost object, ChallengeType challengeType, HttpResponse httpResponse, AuthExchange authExchange, HttpContext httpContext) {
        object = HttpClientContext.cast(httpContext);
        if (this.checkChallenged(challengeType, httpResponse, (HttpClientContext)object)) {
            return true;
        }
        switch (authExchange.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Server has accepted authentication", (Object)((HttpClientContext)object).getExchangeId());
                }
                authExchange.setState(AuthExchange$State.SUCCESS);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authExchange.setState(AuthExchange$State.UNCHALLENGED);
            }
        }
        return false;
    }

    private boolean checkChallenged(ChallengeType challengeType, HttpResponse httpResponse, HttpClientContext httpClientContext) {
        int n2;
        switch (challengeType) {
            case TARGET: {
                n2 = 401;
                break;
            }
            case PROXY: {
                n2 = 407;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected challenge type: " + (Object)((Object)challengeType));
            }
        }
        if (httpResponse.getCode() == n2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Authentication required", (Object)httpClientContext.getExchangeId());
            }
            return true;
        }
        return false;
    }

    public boolean isChallengeExpected(AuthExchange object) {
        return (object = ((AuthExchange)object).getAuthScheme()) != null && object.isChallengeExpected();
    }

    public Map<String, AuthChallenge> extractChallengeMap(ChallengeType challengeType, HttpResponse object, HttpClientContext httpClientContext) {
        HashMap<String, AuthChallenge> hashMap = new HashMap<String, AuthChallenge>();
        object = object.headerIterator(challengeType == ChallengeType.PROXY ? "Proxy-Authenticate" : "WWW-Authenticate");
        while (object.hasNext()) {
            Object object2;
            int n2;
            Object object3;
            Object object4 = (Header)object.next();
            if (object4 instanceof FormattedHeader) {
                object3 = ((FormattedHeader)object4).getBuffer();
                n2 = ((FormattedHeader)object4).getValuePos();
            } else {
                object2 = object4.getValue();
                if (object2 == null) continue;
                object3 = new CharArrayBuffer(((String)object2).length());
                ((CharArrayBuffer)object3).append((String)object2);
                n2 = 0;
            }
            object2 = new ParserCursor(n2, ((CharArrayBuffer)object3).length());
            try {
                object3 = this.parser.parse(challengeType, (CharSequence)object3, (ParserCursor)object2);
            }
            catch (ParseException parseException) {
                if (!LOG.isWarnEnabled()) continue;
                object3 = HttpClientContext.cast(httpClientContext);
                object2 = ((HttpClientContext)object3).getExchangeId();
                LOG.warn("{} Malformed challenge: {}", object2, (Object)object4.getValue());
                continue;
            }
            object4 = object3.iterator();
            while (object4.hasNext()) {
                object3 = (AuthChallenge)object4.next();
                object2 = ((AuthChallenge)object3).getSchemeName().toLowerCase(Locale.ROOT);
                if (hashMap.containsKey(object2)) continue;
                hashMap.put((String)object2, (AuthChallenge)object3);
            }
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    public boolean handleResponse(HttpHost var1_1, ChallengeType var2_2, HttpResponse var3_4, AuthenticationStrategy var4_5, AuthExchange var5_6, HttpContext var6_7) throws AuthenticationException, MalformedChallengeException {
        var6_7 = HttpClientContext.cast(var6_7);
        var7_8 = var6_7.getExchangeId();
        var8_9 = this.checkChallenged((ChallengeType)var2_2, (HttpResponse)var3_4, (HttpClientContext)var6_7);
        var9_10 = this.isChallengeExpected(var5_6);
        if (AuthenticationHandler.LOG.isDebugEnabled()) {
            AuthenticationHandler.LOG.debug("{} {} requested authentication", (Object)var7_8, (Object)var1_1.toHostString());
        }
        if ((var3_4 = this.extractChallengeMap((ChallengeType)var2_2, (HttpResponse)var3_4, (HttpClientContext)var6_7)).isEmpty()) {
            if (AuthenticationHandler.LOG.isDebugEnabled()) {
                AuthenticationHandler.LOG.debug("{} Response contains no valid authentication challenges", (Object)var7_8);
            }
            if (!var9_10) {
                var5_6.reset();
                return false;
            }
        }
        switch (AuthenticationHandler$1.$SwitchMap$org$apache$hc$client5$http$auth$AuthExchange$State[var5_6.getState().ordinal()]) {
            case 4: {
                return false;
            }
            case 3: {
                if (!var9_10) {
                    var5_6.reset();
                    break;
                }
            }
            case 1: 
            case 2: {
                Asserts.notNull(var5_6.getAuthScheme(), "AuthScheme");
            }
            case 5: {
                var10_13 = var5_6.getAuthScheme();
                if (var10_13 == null) break;
                var11_14 = var10_13.getName();
                var12_15 = (AuthChallenge)var3_4.get(var11_14.toLowerCase(Locale.ROOT));
                if (var12_15 == null && !var9_10) ** GOTO lbl51
                if (AuthenticationHandler.LOG.isDebugEnabled()) {
                    AuthenticationHandler.LOG.debug("{} Processing authentication challenge {}", (Object)var7_8, var12_15);
                }
                try {
                    var10_13.processChallenge(var1_1, var8_9, (AuthChallenge)var12_15, var6_7);
                }
                catch (AuthenticationException | MalformedChallengeException var2_3) {
                    if (AuthenticationHandler.LOG.isWarnEnabled()) {
                        AuthenticationHandler.LOG.warn("Exception processing challenge {}", (Object)var7_8, (Object)var2_3);
                    }
                    var5_6.reset();
                    var5_6.setState(AuthExchange$State.FAILURE);
                    if (!var9_10) ** GOTO lbl40
                    throw var2_3;
                }
lbl40:
                // 2 sources

                if (var10_13.isChallengeComplete()) {
                    if (AuthenticationHandler.LOG.isDebugEnabled()) {
                        AuthenticationHandler.LOG.debug("{} Authentication failed", (Object)var7_8);
                    }
                    var5_6.reset();
                    var5_6.setState(AuthExchange$State.FAILURE);
                    return false;
                }
                if (!var8_9) {
                    var5_6.setState(AuthExchange$State.SUCCESS);
                    return false;
                }
                var5_6.setState(AuthExchange$State.HANDSHAKE);
                return true;
lbl51:
                // 1 sources

                var5_6.reset();
            }
        }
        var10_13 = var4_5.select((ChallengeType)var2_2, (Map<String, AuthChallenge>)var3_4, var6_7);
        var11_14 = var6_7.getCredentialsProvider();
        if (var11_14 == null) {
            if (AuthenticationHandler.LOG.isDebugEnabled()) {
                AuthenticationHandler.LOG.debug("{} Credentials provider not set in the context", (Object)var7_8);
            }
            return false;
        }
        var12_15 = new LinkedList<E>();
        if (AuthenticationHandler.LOG.isDebugEnabled()) {
            AuthenticationHandler.LOG.debug("{} Selecting authentication options", (Object)var7_8);
        }
        var2_2 = var10_13.iterator();
        while (var2_2.hasNext()) {
            var4_5 = (AuthScheme)var2_2.next();
            try {
                var9_11 = var4_5.getName();
                var9_11 = (AuthChallenge)var3_4.get(var9_11.toLowerCase(Locale.ROOT));
                var4_5.processChallenge(var1_1, var8_9, (AuthChallenge)var9_11, var6_7);
                if (!var4_5.isResponseReady(var1_1, (CredentialsProvider)var11_14, var6_7)) continue;
                var12_15.add(var4_5);
            }
            catch (AuthenticationException | MalformedChallengeException var9_12) {
                if (!AuthenticationHandler.LOG.isWarnEnabled()) continue;
                AuthenticationHandler.LOG.warn("Exception while processing Challange", var9_12);
            }
        }
        if (!var12_15.isEmpty()) {
            if (AuthenticationHandler.LOG.isDebugEnabled()) {
                AuthenticationHandler.LOG.debug("{} Selected authentication options: {}", (Object)var7_8, var12_15);
            }
            var5_6.reset();
            var5_6.setState(AuthExchange$State.CHALLENGED);
            var5_6.setOptions((Queue<AuthScheme>)var12_15);
            return true;
        }
        return false;
    }

    public void addAuthResponse(HttpHost httpHost, ChallengeType challengeType, HttpRequest httpRequest, AuthExchange authExchange, HttpContext httpContext) {
        block15: {
            Object object;
            httpContext = HttpClientContext.cast(httpContext);
            String string = ((HttpClientContext)httpContext).getExchangeId();
            AuthScheme authScheme = authExchange.getAuthScheme();
            switch (authExchange.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    Asserts.notNull(authScheme, "AuthScheme");
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case HANDSHAKE: {
                    Asserts.notNull(authScheme, "AuthScheme");
                    break;
                }
                case CHALLENGED: {
                    object = authExchange.getAuthOptions();
                    if (object != null) {
                        while (!object.isEmpty()) {
                            authScheme = object.remove();
                            authExchange.select(authScheme);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} Generating response to an authentication challenge using {} scheme", (Object)string, (Object)authScheme.getName());
                            }
                            try {
                                Object object2 = authScheme.generateAuthResponse(httpHost, httpRequest, httpContext);
                                if (object2 != null) {
                                    object2 = new BasicHeader(challengeType == ChallengeType.TARGET ? "Authorization" : "Proxy-Authorization", object2);
                                    httpRequest.addHeader((Header)object2);
                                }
                                return;
                            }
                            catch (AuthenticationException authenticationException) {
                                if (!LOG.isWarnEnabled()) continue;
                                LOG.warn("{} {} authentication error: {}", string, authScheme, authenticationException.getMessage());
                            }
                        }
                        return;
                    }
                    Asserts.notNull(authScheme, "AuthScheme");
                }
            }
            if (authScheme != null) {
                try {
                    object = authScheme.generateAuthResponse(httpHost, httpRequest, httpContext);
                    BasicHeader basicHeader = new BasicHeader(challengeType == ChallengeType.TARGET ? "Authorization" : "Proxy-Authorization", object);
                    httpRequest.addHeader(basicHeader);
                    return;
                }
                catch (AuthenticationException authenticationException) {
                    if (!LOG.isErrorEnabled()) break block15;
                    LOG.error("{} {} authentication error: {}", string, authScheme, authenticationException.getMessage());
                }
            }
        }
    }
}

