/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthStateCacheable;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.BearerToken;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.impl.StateHolder;
import org.apache.hc.client5.http.impl.auth.BearerScheme$State;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthStateCacheable
public class BearerScheme
implements Serializable,
AuthScheme,
StateHolder<BearerScheme$State> {
    private static final Logger LOG = LoggerFactory.getLogger(BearerScheme.class);
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private boolean complete = false;
    private BearerToken bearerToken;

    @Override
    public String getName() {
        return "Bearer";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getRealm() {
        return this.paramMap.get("realm");
    }

    @Override
    public void processChallenge(AuthChallenge object, HttpContext object2) throws MalformedChallengeException {
        this.paramMap.clear();
        object = ((AuthChallenge)object).getParams();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (NameValuePair)object.next();
                this.paramMap.put(object2.getName().toLowerCase(Locale.ROOT), object2.getValue());
            }
            if (LOG.isDebugEnabled() && (object = this.paramMap.get("error")) != null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object);
                object = this.paramMap.get("error_description");
                String string = this.paramMap.get("error_uri");
                if (object != null || string != null) {
                    ((StringBuilder)object2).append(" (");
                    ((StringBuilder)object2).append((String)object).append("; ").append(string);
                    ((StringBuilder)object2).append(")");
                }
                LOG.debug(((StringBuilder)object2).toString());
            }
        }
        this.complete = true;
    }

    @Override
    public boolean isChallengeComplete() {
        return this.complete;
    }

    @Override
    public boolean isResponseReady(HttpHost object, CredentialsProvider object2, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(object, "Auth host");
        Args.notNull(object2, "Credentials provider");
        object = new AuthScope((HttpHost)object, this.getRealm(), this.getName());
        object2 = object2.getCredentials((AuthScope)object, httpContext);
        if (object2 instanceof BearerToken) {
            this.bearerToken = (BearerToken)object2;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            object2 = HttpClientContext.cast(httpContext);
            object2 = ((HttpClientContext)object2).getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", object2, object);
        }
        this.bearerToken = null;
        return false;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public String generateAuthResponse(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        Asserts.notNull(this.bearerToken, "Bearer token");
        return "Bearer " + this.bearerToken.getToken();
    }

    @Override
    public BearerScheme$State store() {
        if (this.complete) {
            return new BearerScheme$State(new HashMap<String, String>(this.paramMap), this.bearerToken);
        }
        return null;
    }

    @Override
    public void restore(BearerScheme$State bearerScheme$State) {
        if (bearerScheme$State != null) {
            this.paramMap.clear();
            this.paramMap.putAll(bearerScheme$State.params);
            this.bearerToken = bearerScheme$State.bearerToken;
            this.complete = true;
        }
    }

    public String toString() {
        return this.getName() + this.paramMap;
    }
}

