/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hc.client5.http.impl.auth.NTLMEngineException;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl$Mode;

class NTLMEngineImpl$Handle {
    private final byte[] signingKey;
    private byte[] sealingKey;
    private final Cipher rc4;
    final NTLMEngineImpl$Mode mode;
    private final boolean isConnection;
    int sequenceNumber;

    NTLMEngineImpl$Handle(byte[] byArray, NTLMEngineImpl$Mode nTLMEngineImpl$Mode, boolean bl2) throws NTLMEngineException {
        this.isConnection = bl2;
        this.mode = nTLMEngineImpl$Mode;
        try {
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            MessageDigest messageDigest2 = NTLMEngineImpl.getMD5();
            messageDigest.update(byArray);
            messageDigest2.update(byArray);
            if (nTLMEngineImpl$Mode == NTLMEngineImpl$Mode.CLIENT) {
                messageDigest.update(NTLMEngineImpl.access$1000());
                messageDigest2.update(NTLMEngineImpl.access$1100());
            } else {
                messageDigest.update(NTLMEngineImpl.access$1200());
                messageDigest2.update(NTLMEngineImpl.access$1300());
            }
            this.signingKey = messageDigest.digest();
            this.sealingKey = messageDigest2.digest();
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
        this.rc4 = this.initCipher();
    }

    byte[] getSigningKey() {
        return this.signingKey;
    }

    byte[] getSealingKey() {
        return this.sealingKey;
    }

    private Cipher initCipher() throws NTLMEngineException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("RC4");
            if (this.mode == NTLMEngineImpl$Mode.CLIENT) {
                cipher.init(1, new SecretKeySpec(this.sealingKey, "RC4"));
            } else {
                cipher.init(2, new SecretKeySpec(this.sealingKey, "RC4"));
            }
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
        return cipher;
    }

    private void advanceMessageSequence() throws NTLMEngineException {
        if (!this.isConnection) {
            MessageDigest messageDigest = NTLMEngineImpl.getMD5();
            messageDigest.update(this.sealingKey);
            byte[] byArray = new byte[4];
            NTLMEngineImpl.writeULong(byArray, this.sequenceNumber, 0);
            messageDigest.update(byArray);
            this.sealingKey = messageDigest.digest();
            this.initCipher();
        }
        ++this.sequenceNumber;
    }

    private byte[] encrypt(byte[] byArray) {
        return this.rc4.update(byArray);
    }

    private byte[] decrypt(byte[] byArray) {
        return this.rc4.update(byArray);
    }

    private byte[] computeSignature(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = byArray2;
        byArray2[0] = 1;
        byArray3[1] = 0;
        byArray3[2] = 0;
        byArray3[3] = 0;
        Object object = new NTLMEngineImpl$HMACMD5(this.signingKey);
        ((NTLMEngineImpl$HMACMD5)object).update(NTLMEngineImpl.access$1400(this.sequenceNumber));
        ((NTLMEngineImpl$HMACMD5)object).update(byArray);
        byArray = ((NTLMEngineImpl$HMACMD5)object).getOutput();
        object = new byte[8];
        System.arraycopy(byArray, 0, object, 0, 8);
        byArray = this.encrypt((byte[])object);
        System.arraycopy(byArray, 0, byArray3, 4, 8);
        NTLMEngineImpl.access$1500(byArray3, 12, this.sequenceNumber);
        return byArray3;
    }

    private boolean validateSignature(byte[] byArray, byte[] byArray2) {
        byArray2 = this.computeSignature(byArray2);
        return MessageDigest.isEqual(byArray, byArray2);
    }

    byte[] signAndEncryptMessage(byte[] byArray) throws NTLMEngineException {
        byte[] byArray2 = this.encrypt(byArray);
        byArray = this.computeSignature(byArray);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        this.advanceMessageSequence();
        return byArray3;
    }

    byte[] decryptAndVerifySignedMessage(byte[] byArray) throws NTLMEngineException {
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[byArray.length - 16];
        System.arraycopy(byArray, 16, byArray3, 0, byArray3.length);
        byArray = this.decrypt(byArray3);
        if (!this.validateSignature(byArray2, byArray)) {
            throw new NTLMEngineException("Wrong signature");
        }
        this.advanceMessageSequence();
        return byArray;
    }
}

