/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.impl.auth.NTLMEngineException;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl;
import org.apache.hc.client5.http.utils.Base64;

class NTLMEngineImpl$NTLMMessage {
    byte[] messageContents;
    int currentOutputPosition;

    NTLMEngineImpl$NTLMMessage() {
    }

    NTLMEngineImpl$NTLMMessage(String string, int n2) throws NTLMEngineException {
        this(Base64.decodeBase64(string.getBytes(NTLMEngineImpl.access$1600())), n2);
    }

    NTLMEngineImpl$NTLMMessage(byte[] byArray, int n2) throws NTLMEngineException {
        int n3;
        this.messageContents = byArray;
        if (this.messageContents.length < NTLMEngineImpl.access$1700().length) {
            throw new NTLMEngineException("NTLM message decoding error - packet too short");
        }
        for (n3 = 0; n3 < NTLMEngineImpl.access$1700().length; ++n3) {
            if (this.messageContents[n3] == NTLMEngineImpl.access$1700()[n3]) continue;
            throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
        }
        n3 = this.readULong(NTLMEngineImpl.access$1700().length);
        if (n3 != n2) {
            throw new NTLMEngineException("NTLM type " + n2 + " message expected - instead got type " + n3);
        }
        this.currentOutputPosition = this.messageContents.length;
    }

    int getPreambleLength() {
        return NTLMEngineImpl.access$1700().length + 4;
    }

    int getMessageLength() {
        return this.currentOutputPosition;
    }

    byte readByte(int n2) throws NTLMEngineException {
        if (this.messageContents.length < n2 + 1) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        return this.messageContents[n2];
    }

    void readBytes(byte[] byArray, int n2) throws NTLMEngineException {
        if (this.messageContents.length < n2 + byArray.length) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        System.arraycopy(this.messageContents, n2, byArray, 0, byArray.length);
    }

    int readUShort(int n2) {
        return NTLMEngineImpl.access$1800(this.messageContents, n2);
    }

    int readULong(int n2) {
        return NTLMEngineImpl.access$1900(this.messageContents, n2);
    }

    byte[] readSecurityBuffer(int n2) {
        return NTLMEngineImpl.access$2000(this.messageContents, n2);
    }

    void prepareResponse(int n2, int n3) {
        this.messageContents = new byte[n2];
        this.currentOutputPosition = 0;
        this.addBytes(NTLMEngineImpl.access$1700());
        this.addULong(n3);
    }

    void addByte(byte by2) {
        this.messageContents[this.currentOutputPosition] = by2;
        ++this.currentOutputPosition;
    }

    void addBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2;
            this.messageContents[this.currentOutputPosition] = by2 = byArray[i2];
            ++this.currentOutputPosition;
        }
    }

    void addUShort(int n2) {
        this.addByte((byte)n2);
        this.addByte((byte)(n2 >> 8));
    }

    void addULong(int n2) {
        this.addByte((byte)n2);
        this.addByte((byte)(n2 >> 8));
        this.addByte((byte)(n2 >> 16));
        this.addByte((byte)(n2 >>> 24));
    }

    String getResponse() {
        return new String(Base64.encodeBase64(this.getBytes()), StandardCharsets.US_ASCII);
    }

    byte[] getBytes() {
        if (this.messageContents == null) {
            this.buildMessage();
        }
        if (this.messageContents.length > this.currentOutputPosition) {
            byte[] byArray = new byte[this.currentOutputPosition];
            System.arraycopy(this.messageContents, 0, byArray, 0, this.currentOutputPosition);
            this.messageContents = byArray;
        }
        return this.messageContents;
    }

    void buildMessage() {
        throw new RuntimeException("Message builder not implemented for " + this.getClass().getName());
    }
}

