/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.security.Principal;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.impl.auth.NTLMEngine;
import org.apache.hc.client5.http.impl.auth.NTLMEngineImpl;
import org.apache.hc.client5.http.impl.auth.NTLMScheme$State;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class NTLMScheme
implements AuthScheme {
    private static final Logger LOG = LoggerFactory.getLogger(NTLMScheme.class);
    private final NTLMEngine engine;
    private NTLMScheme$State state;
    private String challenge;
    private NTCredentials credentials;

    public NTLMScheme(NTLMEngine nTLMEngine) {
        Args.notNull(nTLMEngine, "NTLM engine");
        this.engine = nTLMEngine;
        this.state = NTLMScheme$State.UNINITIATED;
    }

    public NTLMScheme() {
        this(new NTLMEngineImpl());
    }

    @Override
    public final String getName() {
        return "NTLM";
    }

    @Override
    public final boolean isConnectionBased() {
        return true;
    }

    @Override
    public final String getRealm() {
        return null;
    }

    @Override
    public final void processChallenge(AuthChallenge authChallenge, HttpContext httpContext) throws MalformedChallengeException {
        Args.notNull(authChallenge, "AuthChallenge");
        this.challenge = authChallenge.getValue();
        if (this.challenge == null || this.challenge.isEmpty()) {
            if (this.state == NTLMScheme$State.UNINITIATED) {
                this.state = NTLMScheme$State.CHALLENGE_RECEIVED;
                return;
            }
            this.state = NTLMScheme$State.FAILED;
            return;
        }
        if (this.state.compareTo(NTLMScheme$State.MSG_TYPE1_GENERATED) < 0) {
            this.state = NTLMScheme$State.FAILED;
            throw new MalformedChallengeException("Out of sequence NTLM response message");
        }
        if (this.state == NTLMScheme$State.MSG_TYPE1_GENERATED) {
            this.state = NTLMScheme$State.MSG_TYPE2_RECEIVED;
        }
    }

    @Override
    public final boolean isResponseReady(HttpHost object, CredentialsProvider object2, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(object, "Auth host");
        Args.notNull(object2, "CredentialsProvider");
        object = new AuthScope((HttpHost)object, null, this.getName());
        object2 = object2.getCredentials((AuthScope)object, httpContext);
        if (object2 instanceof NTCredentials) {
            this.credentials = (NTCredentials)object2;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            object2 = HttpClientContext.cast(httpContext);
            object2 = ((HttpClientContext)object2).getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", object2, object);
        }
        return false;
    }

    @Override
    public final Principal getPrincipal() {
        if (this.credentials != null) {
            return this.credentials.getUserPrincipal();
        }
        return null;
    }

    @Override
    public final String generateAuthResponse(HttpHost object, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        if (this.credentials == null) {
            throw new AuthenticationException("NT credentials not available");
        }
        if (this.state == NTLMScheme$State.FAILED) {
            throw new AuthenticationException("NTLM authentication failed");
        }
        if (this.state == NTLMScheme$State.CHALLENGE_RECEIVED) {
            object = this.engine.generateType1Msg(this.credentials.getNetbiosDomain(), this.credentials.getWorkstation());
            this.state = NTLMScheme$State.MSG_TYPE1_GENERATED;
        } else if (this.state == NTLMScheme$State.MSG_TYPE2_RECEIVED) {
            object = this.engine.generateType3Msg(this.credentials.getUserName(), this.credentials.getPassword(), this.credentials.getNetbiosDomain(), this.credentials.getWorkstation(), this.challenge);
            this.state = NTLMScheme$State.MSG_TYPE3_GENERATED;
        } else {
            throw new AuthenticationException("Unexpected state: " + (Object)((Object)this.state));
        }
        return "NTLM " + (String)object;
    }

    @Override
    public final boolean isChallengeComplete() {
        return this.state == NTLMScheme$State.MSG_TYPE3_GENERATED || this.state == NTLMScheme$State.FAILED;
    }

    public final String toString() {
        return this.getName() + "{" + (Object)((Object)this.state) + " " + this.challenge + '}';
    }
}

