/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

final class SingleCredentialsProvider
implements CredentialsProvider {
    private final AuthScope authScope;
    private final Credentials credentials;

    public SingleCredentialsProvider(AuthScope authScope, Credentials credentials) {
        this.authScope = Args.notNull(authScope, "Auth scope");
        this.credentials = credentials;
    }

    public SingleCredentialsProvider(AuthScope authScope, String string, char[] cArray) {
        this(authScope, new UsernamePasswordCredentials(string, cArray));
    }

    @Override
    public final Credentials getCredentials(AuthScope authScope, HttpContext httpContext) {
        if (this.authScope.match(authScope) >= 0) {
            return this.credentials;
        }
        return null;
    }

    public final String toString() {
        return this.authScope.toString();
    }
}

