/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class SystemDefaultCredentialsProvider
implements CredentialsStore {
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.internal.setCredentials(authScope, credentials);
    }

    private static PasswordAuthentication getSystemCreds(String string, AuthScope authScope, Authenticator.RequestorType requestorType, HttpClientContext object) {
        object = object != null ? ((HttpCoreContext)object).getRequest() : null;
        try {
            object = object != null ? object.getUri() : null;
            object = object != null ? ((URI)object).toURL() : null;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            object = null;
        }
        return Authenticator.requestPasswordAuthentication(authScope.getHost(), null, authScope.getPort(), string, authScope.getRealm(), authScope.getSchemeName(), (URL)object, requestorType);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope, HttpContext object) {
        Args.notNull(authScope, "Auth scope");
        Object object2 = this.internal.getCredentials(authScope, (HttpContext)object);
        if (object2 != null) {
            return object2;
        }
        object2 = authScope.getHost();
        if (object2 != null) {
            Object object3 = object = object != null ? HttpClientContext.cast((HttpContext)object) : null;
            object2 = authScope.getProtocol() != null ? authScope.getProtocol() : (authScope.getPort() == 443 ? URIScheme.HTTPS.id : URIScheme.HTTP.id);
            PasswordAuthentication passwordAuthentication = SystemDefaultCredentialsProvider.getSystemCreds((String)object2, authScope, Authenticator.RequestorType.SERVER, (HttpClientContext)object);
            if (passwordAuthentication == null) {
                passwordAuthentication = SystemDefaultCredentialsProvider.getSystemCreds((String)object2, authScope, Authenticator.RequestorType.PROXY, (HttpClientContext)object);
            }
            if (passwordAuthentication == null && (passwordAuthentication = SystemDefaultCredentialsProvider.getProxyCredentials(URIScheme.HTTP.getId(), authScope)) == null) {
                passwordAuthentication = SystemDefaultCredentialsProvider.getProxyCredentials(URIScheme.HTTPS.getId(), authScope);
            }
            if (passwordAuthentication != null) {
                object = System.getProperty("http.auth.ntlm.domain");
                if (object != null) {
                    return new NTCredentials(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), null, (String)object);
                }
                if ("NTLM".equalsIgnoreCase(authScope.getSchemeName())) {
                    return new NTCredentials(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), null, null);
                }
                return new UsernamePasswordCredentials(passwordAuthentication.getUserName(), passwordAuthentication.getPassword());
            }
        }
        return null;
    }

    private static PasswordAuthentication getProxyCredentials(String string, AuthScope object) {
        Object object2 = System.getProperty(string + ".proxyHost");
        if (object2 == null) {
            return null;
        }
        String string2 = System.getProperty(string + ".proxyPort");
        if (string2 == null) {
            return null;
        }
        try {
            object2 = new AuthScope((String)object2, Integer.parseInt(string2));
            if (((AuthScope)object).match((AuthScope)object2) >= 0) {
                object = System.getProperty(string + ".proxyUser");
                if (object == null) {
                    return null;
                }
                return new PasswordAuthentication((String)object, (string = System.getProperty(string + ".proxyPassword")) != null ? string.toCharArray() : new char[]{});
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }
}

