/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.classic.AbstractBackoff;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class AIMDBackoffManager
extends AbstractBackoff {
    public AIMDBackoffManager(ConnPoolControl<HttpRoute> connPoolControl) {
        super(connPoolControl);
    }

    @Override
    protected int getBackedOffPoolSize(int n2) {
        if (n2 <= 1) {
            return 1;
        }
        return (int)Math.floor(this.getBackoffFactor().get() * (double)n2);
    }

    @Override
    public void setBackoffFactor(double d2) {
        Args.check(d2 > 0.0 && d2 < 1.0, "Backoff factor must be 0.0 < f < 1.0");
        this.getBackoffFactor().set(d2);
    }
}

