/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.BackoffManager;
import org.apache.hc.client5.http.classic.ConnectionBackoffStrategy;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class BackoffStrategyExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BackoffStrategyExec.class);
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public final ClassicHttpResponse execute(ClassicHttpRequest httpMessage, ExecChain$Scope execChain$Scope, ExecChain execChain) throws IOException, HttpException {
        Args.notNull(httpMessage, "HTTP request");
        Args.notNull(execChain$Scope, "Scope");
        HttpRoute httpRoute = execChain$Scope.route;
        try {
            httpMessage = execChain.proceed((ClassicHttpRequest)httpMessage, execChain$Scope);
        }
        catch (IOException | HttpException exception) {
            if (this.connectionBackoffStrategy.shouldBackoff(exception)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Backing off route {} due to exception: {}", (Object)httpRoute, (Object)exception.getMessage());
                }
                this.backoffManager.backOff(httpRoute);
            }
            throw exception;
        }
        if (this.connectionBackoffStrategy.shouldBackoff((HttpResponse)httpMessage)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Backing off route {} due to response status: {}", (Object)httpRoute, (Object)httpMessage.getCode());
            }
            this.backoffManager.backOff(httpRoute);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probing route: {}", (Object)httpRoute);
            }
            this.backoffManager.probe(httpRoute);
        }
        return httpMessage;
    }
}

