/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.BrotliDecompressingEntity;
import org.apache.hc.client5.http.entity.BrotliInputStreamFactory;
import org.apache.hc.client5.http.entity.DecompressingEntity;
import org.apache.hc.client5.http.entity.DeflateInputStreamFactory;
import org.apache.hc.client5.http.entity.GZIPInputStreamFactory;
import org.apache.hc.client5.http.entity.InputStreamFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ContentCompressionExec
implements ExecChainHandler {
    private final Header acceptEncoding;
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ContentCompressionExec(List<String> object, Lookup<InputStreamFactory> lookup, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = lookup == null && BrotliDecompressingEntity.isAvailable();
        if (object != null) {
            this.acceptEncoding = MessageSupport.headerOfTokens("Accept-Encoding", object);
        } else {
            object = new ArrayList<String>(4);
            object.add((String)"gzip");
            object.add((String)"x-gzip");
            object.add((String)"deflate");
            if (bl3) {
                object.add("br");
            }
            this.acceptEncoding = MessageSupport.headerOfTokens("Accept-Encoding", (List<String>)object);
        }
        if (lookup != null) {
            this.decoderRegistry = lookup;
        } else {
            object = RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance()));
            if (bl3) {
                ((RegistryBuilder)object).register("br", BrotliInputStreamFactory.getInstance());
            }
            this.decoderRegistry = ((RegistryBuilder)object).build();
        }
        this.ignoreUnknown = bl2;
    }

    public ContentCompressionExec(boolean bl2) {
        this(null, null, bl2);
    }

    public ContentCompressionExec() {
        this(null, null, true);
    }

    @Override
    public final ClassicHttpResponse execute(ClassicHttpRequest httpMessage, ExecChain$Scope headerElementArray, ExecChain object) throws IOException, HttpException {
        Args.notNull(httpMessage, "HTTP request");
        Args.notNull(headerElementArray, "Scope");
        Object object2 = headerElementArray.clientContext;
        object2 = ((HttpClientContext)object2).getRequestConfigOrDefault();
        if (!httpMessage.containsHeader("Accept-Encoding") && ((RequestConfig)object2).isContentCompressionEnabled()) {
            httpMessage.addHeader(this.acceptEncoding);
        }
        httpMessage = object.proceed((ClassicHttpRequest)httpMessage, (ExecChain$Scope)headerElementArray);
        headerElementArray = httpMessage.getEntity();
        if (((RequestConfig)object2).isContentCompressionEnabled() && headerElementArray != null && headerElementArray.getContentLength() != 0L && (headerElementArray = headerElementArray.getContentEncoding()) != null) {
            object = new ParserCursor(0, headerElementArray.length());
            HeaderElement[] headerElementArray2 = BasicHeaderValueParser.INSTANCE.parseElements((CharSequence)headerElementArray, (ParserCursor)object);
            headerElementArray = headerElementArray2;
            headerElementArray = headerElementArray2;
            int n2 = headerElementArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                HeaderElement headerElement = headerElementArray[i2];
                String string = headerElement.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory inputStreamFactory = this.decoderRegistry.lookup(string);
                if (inputStreamFactory != null) {
                    httpMessage.setEntity(new DecompressingEntity(httpMessage.getEntity(), inputStreamFactory));
                    httpMessage.removeHeaders("Content-Length");
                    httpMessage.removeHeaders("Content-Encoding");
                    httpMessage.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(string) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + headerElement.getName());
            }
        }
        return httpMessage;
    }
}

