/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.classic.AbstractBackoff;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackoffManager
extends AbstractBackoff {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackoffManager.class);

    public ExponentialBackoffManager(ConnPoolControl<HttpRoute> connPoolControl) {
        super(connPoolControl);
    }

    @Override
    protected int getBackedOffPoolSize(int n2) {
        if (n2 <= 1) {
            return 1;
        }
        int n3 = this.getTimeInterval().incrementAndGet();
        int n4 = Math.max(1, (int)Math.floor((double)n2 / Math.pow(1.0 + this.getBackoffFactor().get(), n3)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("curr={}, t={}, growthRate={}, result={}", n2, n3, this.getBackoffFactor().get(), n4);
        }
        return n4;
    }

    @Override
    public void setBackoffFactor(double d2) {
        Args.check(d2 > 0.0, "Growth rate must be greater than 0.0");
        this.getBackoffFactor().set(d2);
    }
}

