/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.BackoffManager;
import org.apache.hc.client5.http.classic.ConnectionBackoffStrategy;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.InputStreamFactory;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.CookieSpecSupport;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultUserTokenHandler;
import org.apache.hc.client5.http.impl.IdleConnectionEvictor;
import org.apache.hc.client5.http.impl.NoopUserTokenHandler;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.BearerSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.BackoffStrategyExec;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.ConnectExec;
import org.apache.hc.client5.http.impl.classic.ContentCompressionExec;
import org.apache.hc.client5.http.impl.classic.ExecChainElement;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder$ExecInterceptorEntry;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder$ExecInterceptorEntry$Position;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder$RequestInterceptorEntry;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder$RequestInterceptorEntry$Position;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder$ResponseInterceptorEntry;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder$ResponseInterceptorEntry$Position;
import org.apache.hc.client5.http.impl.classic.HttpRequestRetryExec;
import org.apache.hc.client5.http.impl.classic.InternalHttpClient;
import org.apache.hc.client5.http.impl.classic.MainClientExec;
import org.apache.hc.client5.http.impl.classic.ProtocolExec;
import org.apache.hc.client5.http.impl.classic.RedirectExec;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.protocol.RequestAddCookies;
import org.apache.hc.client5.http.protocol.RequestClientConnControl;
import org.apache.hc.client5.http.protocol.RequestDefaultHeaders;
import org.apache.hc.client5.http.protocol.RequestExpectContinue;
import org.apache.hc.client5.http.protocol.RequestUpgrade;
import org.apache.hc.client5.http.protocol.RequestValidateTrace;
import org.apache.hc.client5.http.protocol.ResponseProcessCookies;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.config.NamedElementChain$Node;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.hc.core5.util.VersionInfo;

public class HttpClientBuilder {
    private HttpRequestExecutor requestExec;
    private HttpClientConnectionManager connManager;
    private boolean connManagerShared;
    private SchemePortResolver schemePortResolver;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private AuthenticationStrategy targetAuthStrategy;
    private AuthenticationStrategy proxyAuthStrategy;
    private UserTokenHandler userTokenHandler;
    private LinkedList<HttpClientBuilder$RequestInterceptorEntry> requestInterceptors;
    private LinkedList<HttpClientBuilder$ResponseInterceptorEntry> responseInterceptors;
    private LinkedList<HttpClientBuilder$ExecInterceptorEntry> execInterceptors;
    private HttpRequestRetryStrategy retryStrategy;
    private HttpRoutePlanner routePlanner;
    private RedirectStrategy redirectStrategy;
    private ConnectionBackoffStrategy connectionBackoffStrategy;
    private BackoffManager backoffManager;
    private Lookup<AuthSchemeFactory> authSchemeRegistry;
    private Lookup<CookieSpecFactory> cookieSpecRegistry;
    private LinkedHashMap<String, InputStreamFactory> contentDecoderMap;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private String userAgent;
    private HttpHost proxy;
    private Collection<? extends Header> defaultHeaders;
    private RequestConfig defaultRequestConfig;
    private boolean evictExpiredConnections;
    private boolean evictIdleConnections;
    private TimeValue maxIdleTime;
    private boolean systemProperties;
    private boolean redirectHandlingDisabled;
    private boolean automaticRetriesDisabled;
    private boolean contentCompressionDisabled;
    private boolean cookieManagementDisabled;
    private boolean authCachingDisabled;
    private boolean connectionStateDisabled;
    private boolean defaultUserAgentDisabled;
    private ProxySelector proxySelector;
    private List<Closeable> closeables;

    public static HttpClientBuilder create() {
        return new HttpClientBuilder();
    }

    protected HttpClientBuilder() {
    }

    public final HttpClientBuilder setRequestExecutor(HttpRequestExecutor httpRequestExecutor) {
        this.requestExec = httpRequestExecutor;
        return this;
    }

    public final HttpClientBuilder setConnectionManager(HttpClientConnectionManager httpClientConnectionManager) {
        this.connManager = httpClientConnectionManager;
        return this;
    }

    public final HttpClientBuilder setConnectionManagerShared(boolean bl2) {
        this.connManagerShared = bl2;
        return this;
    }

    public final HttpClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.reuseStrategy = connectionReuseStrategy;
        return this;
    }

    public final HttpClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.keepAliveStrategy = connectionKeepAliveStrategy;
        return this;
    }

    public final HttpClientBuilder setTargetAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.targetAuthStrategy = authenticationStrategy;
        return this;
    }

    public final HttpClientBuilder setProxyAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.proxyAuthStrategy = authenticationStrategy;
        return this;
    }

    public final HttpClientBuilder setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.userTokenHandler = userTokenHandler;
        return this;
    }

    public final HttpClientBuilder disableConnectionState() {
        this.connectionStateDisabled = true;
        return this;
    }

    public final HttpClientBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final HttpClientBuilder setUserAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public final HttpClientBuilder setDefaultHeaders(Collection<? extends Header> collection) {
        this.defaultHeaders = collection;
        return this;
    }

    public final HttpClientBuilder addResponseInterceptorFirst(HttpResponseInterceptor httpResponseInterceptor) {
        Args.notNull(httpResponseInterceptor, "Interceptor");
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new LinkedList();
        }
        this.responseInterceptors.add(new HttpClientBuilder$ResponseInterceptorEntry(HttpClientBuilder$ResponseInterceptorEntry$Position.FIRST, httpResponseInterceptor, null));
        return this;
    }

    public final HttpClientBuilder addResponseInterceptorLast(HttpResponseInterceptor httpResponseInterceptor) {
        Args.notNull(httpResponseInterceptor, "Interceptor");
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new LinkedList();
        }
        this.responseInterceptors.add(new HttpClientBuilder$ResponseInterceptorEntry(HttpClientBuilder$ResponseInterceptorEntry$Position.LAST, httpResponseInterceptor, null));
        return this;
    }

    public final HttpClientBuilder addRequestInterceptorFirst(HttpRequestInterceptor httpRequestInterceptor) {
        Args.notNull(httpRequestInterceptor, "Interceptor");
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new LinkedList();
        }
        this.requestInterceptors.add(new HttpClientBuilder$RequestInterceptorEntry(HttpClientBuilder$RequestInterceptorEntry$Position.FIRST, httpRequestInterceptor, null));
        return this;
    }

    public final HttpClientBuilder addRequestInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        Args.notNull(httpRequestInterceptor, "Interceptor");
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new LinkedList();
        }
        this.requestInterceptors.add(new HttpClientBuilder$RequestInterceptorEntry(HttpClientBuilder$RequestInterceptorEntry$Position.LAST, httpRequestInterceptor, null));
        return this;
    }

    public final HttpClientBuilder addExecInterceptorBefore(String string, String string2, ExecChainHandler execChainHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(execChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new HttpClientBuilder$ExecInterceptorEntry(HttpClientBuilder$ExecInterceptorEntry$Position.BEFORE, string2, execChainHandler, string, null));
        return this;
    }

    public final HttpClientBuilder addExecInterceptorAfter(String string, String string2, ExecChainHandler execChainHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(execChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new HttpClientBuilder$ExecInterceptorEntry(HttpClientBuilder$ExecInterceptorEntry$Position.AFTER, string2, execChainHandler, string, null));
        return this;
    }

    public final HttpClientBuilder replaceExecInterceptor(String string, ExecChainHandler execChainHandler) {
        Args.notBlank(string, "Existing");
        Args.notNull(execChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new HttpClientBuilder$ExecInterceptorEntry(HttpClientBuilder$ExecInterceptorEntry$Position.REPLACE, string, execChainHandler, string, null));
        return this;
    }

    public final HttpClientBuilder addExecInterceptorFirst(String string, ExecChainHandler execChainHandler) {
        Args.notNull(string, "Name");
        Args.notNull(execChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new HttpClientBuilder$ExecInterceptorEntry(HttpClientBuilder$ExecInterceptorEntry$Position.FIRST, string, execChainHandler, null, null));
        return this;
    }

    public final HttpClientBuilder addExecInterceptorLast(String string, ExecChainHandler execChainHandler) {
        Args.notNull(string, "Name");
        Args.notNull(execChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new HttpClientBuilder$ExecInterceptorEntry(HttpClientBuilder$ExecInterceptorEntry$Position.LAST, string, execChainHandler, null, null));
        return this;
    }

    public final HttpClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public final HttpClientBuilder disableContentCompression() {
        this.contentCompressionDisabled = true;
        return this;
    }

    public final HttpClientBuilder disableAuthCaching() {
        this.authCachingDisabled = true;
        return this;
    }

    public final HttpClientBuilder setRetryStrategy(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        this.retryStrategy = httpRequestRetryStrategy;
        return this;
    }

    public final HttpClientBuilder disableAutomaticRetries() {
        this.automaticRetriesDisabled = true;
        return this;
    }

    public final HttpClientBuilder setProxy(HttpHost httpHost) {
        this.proxy = httpHost;
        return this;
    }

    public final HttpClientBuilder setRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
        this.routePlanner = httpRoutePlanner;
        return this;
    }

    public final HttpClientBuilder setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public final HttpClientBuilder disableRedirectHandling() {
        this.redirectHandlingDisabled = true;
        return this;
    }

    public final HttpClientBuilder setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        return this;
    }

    public final HttpClientBuilder setBackoffManager(BackoffManager backoffManager) {
        this.backoffManager = backoffManager;
        return this;
    }

    public final HttpClientBuilder setDefaultCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public final HttpClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public final HttpClientBuilder setDefaultAuthSchemeRegistry(Lookup<AuthSchemeFactory> lookup) {
        this.authSchemeRegistry = lookup;
        return this;
    }

    public final HttpClientBuilder setDefaultCookieSpecRegistry(Lookup<CookieSpecFactory> lookup) {
        this.cookieSpecRegistry = lookup;
        return this;
    }

    public final HttpClientBuilder setContentDecoderRegistry(LinkedHashMap<String, InputStreamFactory> linkedHashMap) {
        this.contentDecoderMap = linkedHashMap;
        return this;
    }

    public final HttpClientBuilder setDefaultRequestConfig(RequestConfig requestConfig) {
        this.defaultRequestConfig = requestConfig;
        return this;
    }

    public final HttpClientBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    public final HttpClientBuilder evictExpiredConnections() {
        this.evictExpiredConnections = true;
        return this;
    }

    public final HttpClientBuilder evictIdleConnections(TimeValue timeValue) {
        this.evictIdleConnections = true;
        this.maxIdleTime = timeValue;
        return this;
    }

    public final HttpClientBuilder disableDefaultUserAgent() {
        this.defaultUserAgentDisabled = true;
        return this;
    }

    public final HttpClientBuilder setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    @Internal
    protected void customizeExecChain(NamedElementChain<ExecChainHandler> namedElementChain) {
    }

    @Internal
    protected void addCloseable(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (this.closeables == null) {
            this.closeables = new ArrayList<Closeable>();
        }
        this.closeables.add(closeable);
    }

    @Internal
    protected Function<HttpContext, HttpClientContext> contextAdaptor() {
        return HttpClientContext::castOrCreate;
    }

    /*
     * WARNING - void declaration
     */
    public CloseableHttpClient build() {
        void var6_13;
        void var6_8;
        Object object;
        Object object2;
        AuthenticationStrategy lookup2;
        Object object4;
        Object object5;
        Object object6;
        HttpClientConnectionManager httpClientConnectionManager;
        HttpRequestExecutor httpRequestExecutor = this.requestExec;
        if (httpRequestExecutor == null) {
            httpRequestExecutor = new HttpRequestExecutor();
        }
        if ((httpClientConnectionManager = this.connManager) == null) {
            object6 = PoolingHttpClientConnectionManagerBuilder.create();
            if (this.systemProperties) {
                ((PoolingHttpClientConnectionManagerBuilder)object6).useSystemProperties();
            }
            httpClientConnectionManager = ((PoolingHttpClientConnectionManagerBuilder)object6).build();
        }
        if ((object6 = this.reuseStrategy) == null) {
            object6 = this.systemProperties ? ("true".equalsIgnoreCase((String)(object5 = System.getProperty("http.keepAlive", "true"))) ? DefaultClientConnectionReuseStrategy.INSTANCE : (httpRequest, httpResponse, httpContext) -> false) : DefaultClientConnectionReuseStrategy.INSTANCE;
        }
        if ((object5 = this.keepAliveStrategy) == null) {
            object5 = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((object4 = this.targetAuthStrategy) == null) {
            object4 = DefaultAuthenticationStrategy.INSTANCE;
        }
        if ((lookup2 = this.proxyAuthStrategy) == null) {
            DefaultAuthenticationStrategy defaultAuthenticationStrategy = DefaultAuthenticationStrategy.INSTANCE;
        }
        if ((object2 = this.userTokenHandler) == null) {
            object2 = !this.connectionStateDisabled ? DefaultUserTokenHandler.INSTANCE : NoopUserTokenHandler.INSTANCE;
        }
        if ((object = this.userAgent) == null) {
            if (this.systemProperties) {
                object = System.getProperty("http.agent");
            }
            if (object == null && !this.defaultUserAgentDisabled) {
                object = VersionInfo.getSoftwareInfo("Apache-HttpClient", "org.apache.hc.client5", this.getClass());
            }
        }
        ArrayList<Closeable> arrayList = HttpProcessorBuilder.create();
        if (this.requestInterceptors != null) {
            for (HttpClientBuilder$RequestInterceptorEntry httpClientBuilder$RequestInterceptorEntry : this.requestInterceptors) {
                if (httpClientBuilder$RequestInterceptorEntry.position != HttpClientBuilder$RequestInterceptorEntry$Position.FIRST) continue;
                ((HttpProcessorBuilder)((Object)arrayList)).addFirst(httpClientBuilder$RequestInterceptorEntry.interceptor);
            }
        }
        if (this.responseInterceptors != null) {
            for (HttpClientBuilder$ResponseInterceptorEntry httpClientBuilder$ResponseInterceptorEntry : this.responseInterceptors) {
                if (httpClientBuilder$ResponseInterceptorEntry.position != HttpClientBuilder$ResponseInterceptorEntry$Position.FIRST) continue;
                ((HttpProcessorBuilder)((Object)arrayList)).addFirst(httpClientBuilder$ResponseInterceptorEntry.interceptor);
            }
        }
        ((HttpProcessorBuilder)((Object)arrayList)).addAll(new RequestTargetHost(), new RequestValidateTrace(), new RequestDefaultHeaders(this.defaultHeaders), new RequestContent(), new RequestClientConnControl(), new RequestUserAgent((String)object), new RequestExpectContinue(), new RequestUpgrade());
        if (!this.cookieManagementDisabled) {
            ((HttpProcessorBuilder)((Object)arrayList)).add(RequestAddCookies.INSTANCE);
        }
        if (!this.cookieManagementDisabled) {
            ((HttpProcessorBuilder)((Object)arrayList)).add(ResponseProcessCookies.INSTANCE);
        }
        if (this.requestInterceptors != null) {
            for (HttpClientBuilder$RequestInterceptorEntry httpClientBuilder$RequestInterceptorEntry : this.requestInterceptors) {
                if (httpClientBuilder$RequestInterceptorEntry.position != HttpClientBuilder$RequestInterceptorEntry$Position.LAST) continue;
                ((HttpProcessorBuilder)((Object)arrayList)).addLast(httpClientBuilder$RequestInterceptorEntry.interceptor);
            }
        }
        if (this.responseInterceptors != null) {
            for (HttpClientBuilder$ResponseInterceptorEntry httpClientBuilder$ResponseInterceptorEntry : this.responseInterceptors) {
                if (httpClientBuilder$ResponseInterceptorEntry.position != HttpClientBuilder$ResponseInterceptorEntry$Position.LAST) continue;
                ((HttpProcessorBuilder)((Object)arrayList)).addLast(httpClientBuilder$ResponseInterceptorEntry.interceptor);
            }
        }
        Object object3 = ((HttpProcessorBuilder)((Object)arrayList)).build();
        NamedElementChain<ExecChainHandler> namedElementChain = new NamedElementChain<ExecChainHandler>();
        namedElementChain.addLast(new MainClientExec(httpClientConnectionManager, (HttpProcessor)object3, (ConnectionReuseStrategy)object6, (ConnectionKeepAliveStrategy)object5, (UserTokenHandler)object2), ChainElement.MAIN_TRANSPORT.name());
        namedElementChain.addFirst(new ConnectExec((ConnectionReuseStrategy)object6, new DefaultHttpProcessor(new RequestTargetHost(), new RequestUserAgent((String)object)), (AuthenticationStrategy)var6_8, this.schemePortResolver != null ? this.schemePortResolver : DefaultSchemePortResolver.INSTANCE, this.authCachingDisabled), ChainElement.CONNECT.name());
        namedElementChain.addFirst(new ProtocolExec((AuthenticationStrategy)object4, (AuthenticationStrategy)var6_8, this.schemePortResolver != null ? this.schemePortResolver : DefaultSchemePortResolver.INSTANCE, this.authCachingDisabled), ChainElement.PROTOCOL.name());
        if (!this.contentCompressionDisabled) {
            if (this.contentDecoderMap != null) {
                object6 = new ArrayList<String>(this.contentDecoderMap.keySet());
                object5 = RegistryBuilder.create();
                for (Map.Entry entry : this.contentDecoderMap.entrySet()) {
                    ((RegistryBuilder)object5).register((String)entry.getKey(), entry.getValue());
                }
                object4 = ((RegistryBuilder)object5).build();
                namedElementChain.addFirst(new ContentCompressionExec((List<String>)object6, (Lookup<InputStreamFactory>)object4, true), ChainElement.COMPRESS.name());
            } else {
                namedElementChain.addFirst(new ContentCompressionExec(true), ChainElement.COMPRESS.name());
            }
        }
        if (!this.automaticRetriesDisabled) {
            object6 = this.retryStrategy;
            if (object6 == null) {
                object6 = DefaultHttpRequestRetryStrategy.INSTANCE;
            }
            namedElementChain.addFirst(new HttpRequestRetryExec((HttpRequestRetryStrategy)object6), ChainElement.RETRY.name());
        }
        if ((object6 = this.routePlanner) == null) {
            object5 = this.schemePortResolver;
            if (object5 == null) {
                object5 = DefaultSchemePortResolver.INSTANCE;
            }
            if (this.proxy != null) {
                object6 = new DefaultProxyRoutePlanner(this.proxy, (SchemePortResolver)object5);
            } else if (this.proxySelector != null) {
                object6 = new SystemDefaultRoutePlanner((SchemePortResolver)object5, this.proxySelector);
            } else if (this.systemProperties) {
                object4 = AccessController.doPrivileged(ProxySelector::getDefault);
                object6 = new SystemDefaultRoutePlanner((SchemePortResolver)object5, (ProxySelector)object4);
            } else {
                object6 = new DefaultRoutePlanner((SchemePortResolver)object5);
            }
        }
        if (!this.redirectHandlingDisabled) {
            object5 = this.redirectStrategy;
            if (object5 == null) {
                object5 = this.schemePortResolver != null ? new DefaultRedirectStrategy(this.schemePortResolver) : DefaultRedirectStrategy.INSTANCE;
            }
            namedElementChain.addFirst(new RedirectExec((HttpRoutePlanner)object6, (RedirectStrategy)object5), ChainElement.REDIRECT.name());
        }
        if (this.backoffManager != null && this.connectionBackoffStrategy != null) {
            namedElementChain.addFirst(new BackoffStrategyExec(this.connectionBackoffStrategy, this.backoffManager), ChainElement.BACK_OFF.name());
        }
        if (this.execInterceptors != null) {
            object5 = this.execInterceptors.iterator();
            while (object5.hasNext()) {
                object4 = (HttpClientBuilder$ExecInterceptorEntry)object5.next();
                switch (((HttpClientBuilder$ExecInterceptorEntry)object4).position) {
                    case AFTER: {
                        namedElementChain.addAfter(((HttpClientBuilder$ExecInterceptorEntry)object4).existing, ((HttpClientBuilder$ExecInterceptorEntry)object4).interceptor, ((HttpClientBuilder$ExecInterceptorEntry)object4).name);
                        break;
                    }
                    case BEFORE: {
                        namedElementChain.addBefore(((HttpClientBuilder$ExecInterceptorEntry)object4).existing, ((HttpClientBuilder$ExecInterceptorEntry)object4).interceptor, ((HttpClientBuilder$ExecInterceptorEntry)object4).name);
                        break;
                    }
                    case REPLACE: {
                        namedElementChain.replace(((HttpClientBuilder$ExecInterceptorEntry)object4).existing, ((HttpClientBuilder$ExecInterceptorEntry)object4).interceptor);
                        break;
                    }
                    case FIRST: {
                        namedElementChain.addFirst(((HttpClientBuilder$ExecInterceptorEntry)object4).interceptor, ((HttpClientBuilder$ExecInterceptorEntry)object4).name);
                        break;
                    }
                    case LAST: {
                        namedElementChain.addBefore(ChainElement.MAIN_TRANSPORT.name(), ((HttpClientBuilder$ExecInterceptorEntry)object4).interceptor, ((HttpClientBuilder$ExecInterceptorEntry)object4).name);
                    }
                }
            }
        }
        this.customizeExecChain(namedElementChain);
        object4 = null;
        for (object5 = namedElementChain.getLast(); object5 != null; object5 = ((NamedElementChain$Node)object5).getPrevious()) {
            object4 = new ExecChainElement((ExecChainHandler)((NamedElementChain$Node)object5).getValue(), (ExecChainElement)object4);
        }
        Lookup<AuthSchemeFactory> lookup = this.authSchemeRegistry;
        if (lookup == null) {
            Registry<BasicSchemeFactory> registry = RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).register("Digest", (BasicSchemeFactory)((Object)DigestSchemeFactory.INSTANCE)).register("Bearer", (BasicSchemeFactory)((Object)BearerSchemeFactory.INSTANCE)).build();
        }
        if ((object5 = this.cookieSpecRegistry) == null) {
            object5 = CookieSpecSupport.createDefault();
        }
        if ((object2 = this.cookieStore) == null) {
            object2 = new BasicCookieStore();
        }
        if ((object = this.credentialsProvider) == null) {
            object = this.systemProperties ? new SystemDefaultCredentialsProvider() : new BasicCredentialsProvider();
        }
        ArrayList<Closeable> arrayList2 = arrayList = this.closeables != null ? new ArrayList<Closeable>(this.closeables) : null;
        if (!this.connManagerShared) {
            if (arrayList == null) {
                arrayList = new ArrayList<Closeable>(1);
            }
            if ((this.evictExpiredConnections || this.evictIdleConnections) && httpClientConnectionManager instanceof ConnPoolControl) {
                object3 = new IdleConnectionEvictor((ConnPoolControl)((Object)httpClientConnectionManager), this.maxIdleTime, this.maxIdleTime);
                arrayList.add(() -> HttpClientBuilder.lambda$build$1((IdleConnectionEvictor)object3));
                ((IdleConnectionEvictor)object3).start();
            }
            arrayList.add(httpClientConnectionManager);
        }
        return new InternalHttpClient(httpClientConnectionManager, httpRequestExecutor, (ExecChainElement)object4, (HttpRoutePlanner)object6, (Lookup<CookieSpecFactory>)object5, (Lookup<AuthSchemeFactory>)var6_13, (CookieStore)object2, (CredentialsProvider)object, this.contextAdaptor(), this.defaultRequestConfig != null ? this.defaultRequestConfig : RequestConfig.DEFAULT, (List<Closeable>)arrayList);
    }

    private static /* synthetic */ void lambda$build$1(IdleConnectionEvictor idleConnectionEvictor) throws IOException {
        idleConnectionEvictor.shutdown();
        try {
            idleConnectionEvictor.awaitTermination(Timeout.ofSeconds(1L));
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

