/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.util.concurrent.FutureTask;
import org.apache.hc.client5.http.impl.classic.HttpRequestTaskCallable;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.http.ClassicHttpRequest;

final class HttpRequestFutureTask<V>
extends FutureTask<V> {
    private final ClassicHttpRequest request;
    private final HttpRequestTaskCallable<V> callable;

    HttpRequestFutureTask(ClassicHttpRequest classicHttpRequest, HttpRequestTaskCallable<V> httpRequestTaskCallable) {
        super(httpRequestTaskCallable);
        this.request = classicHttpRequest;
        this.callable = httpRequestTaskCallable;
    }

    @Override
    public final boolean cancel(boolean bl2) {
        this.callable.cancel();
        if (bl2 && this.request instanceof Cancellable) {
            ((Cancellable)((Object)this.request)).cancel();
        }
        return super.cancel(bl2);
    }

    public final long scheduledTime() {
        return this.callable.getScheduled();
    }

    public final long startedTime() {
        return this.callable.getStarted();
    }

    public final long endedTime() {
        if (this.isDone()) {
            return this.callable.getEnded();
        }
        throw new IllegalStateException("Task is not done yet");
    }

    public final long requestDuration() {
        if (this.isDone()) {
            return this.endedTime() - this.startedTime();
        }
        throw new IllegalStateException("Task is not done yet");
    }

    public final long taskDuration() {
        if (this.isDone()) {
            return this.endedTime() - this.scheduledTime();
        }
        throw new IllegalStateException("Task is not done yet");
    }

    @Override
    public final String toString() {
        return this.request.toString();
    }
}

