/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class InternalExecRuntime
implements ExecRuntime,
Cancellable {
    private final Logger log;
    private final HttpClientConnectionManager manager;
    private final HttpRequestExecutor requestExecutor;
    private final CancellableDependency cancellableDependency;
    private final AtomicReference<ConnectionEndpoint> endpointRef;
    private volatile boolean reusable;
    private volatile Object state;
    private volatile TimeValue validDuration;

    InternalExecRuntime(Logger logger, HttpClientConnectionManager httpClientConnectionManager, HttpRequestExecutor httpRequestExecutor, CancellableDependency cancellableDependency) {
        this.log = logger;
        this.manager = httpClientConnectionManager;
        this.requestExecutor = httpRequestExecutor;
        this.cancellableDependency = cancellableDependency;
        this.endpointRef = new AtomicReference();
        this.validDuration = TimeValue.NEG_ONE_MILLISECOND;
    }

    @Override
    public boolean isExecutionAborted() {
        return this.cancellableDependency != null && this.cancellableDependency.isCancelled();
    }

    @Override
    public boolean isEndpointAcquired() {
        return this.endpointRef.get() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void acquireEndpoint(String object, HttpRoute object2, Object object3, HttpClientContext object4) throws IOException {
        Args.notNull(object2, "Route");
        if (this.endpointRef.get() != null) throw new IllegalStateException("Endpoint already acquired");
        object4 = ((HttpClientContext)object4).getRequestConfigOrDefault();
        object4 = ((RequestConfig)object4).getConnectionRequestTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} acquiring endpoint ({})", object, object4);
        }
        object2 = this.manager.lease((String)object, (HttpRoute)object2, (Timeout)object4, object3);
        this.state = object3;
        if (this.cancellableDependency != null) {
            this.cancellableDependency.setDependency((Cancellable)object2);
        }
        try {
            object3 = object2.get((Timeout)object4);
            this.endpointRef.set((ConnectionEndpoint)object3);
            this.reusable = ((ConnectionEndpoint)object3).isConnected();
            if (this.cancellableDependency != null) {
                this.cancellableDependency.setDependency(this);
            }
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("{} acquired endpoint {}", object, (Object)ConnPoolSupport.getId(object3));
            return;
        }
        catch (TimeoutException timeoutException) {
            object2.cancel();
            throw new ConnectionRequestTimeoutException(timeoutException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            object2.cancel();
            Thread.currentThread().interrupt();
            throw new RequestFailedException("Request aborted", interruptedException);
        }
        catch (ExecutionException executionException) {
            object2.cancel();
            object = executionException.getCause();
            if (object != null) throw new RequestFailedException("Request execution failed", (Throwable)object);
            object = executionException;
            throw new RequestFailedException("Request execution failed", (Throwable)object);
        }
    }

    ConnectionEndpoint ensureValid() {
        ConnectionEndpoint connectionEndpoint = this.endpointRef.get();
        if (connectionEndpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return connectionEndpoint;
    }

    @Override
    public boolean isEndpointConnected() {
        ConnectionEndpoint connectionEndpoint = this.endpointRef.get();
        return connectionEndpoint != null && connectionEndpoint.isConnected();
    }

    private void connectEndpoint(ConnectionEndpoint connectionEndpoint, HttpClientContext httpClientContext) throws IOException {
        if (this.isExecutionAborted()) {
            throw new RequestFailedException("Request aborted");
        }
        Object object = httpClientContext.getRequestConfigOrDefault();
        object = ((RequestConfig)object).getConnectTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} connecting endpoint ({})", (Object)ConnPoolSupport.getId(connectionEndpoint), object);
        }
        this.manager.connect(connectionEndpoint, (TimeValue)object, httpClientContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} endpoint connected", (Object)ConnPoolSupport.getId(connectionEndpoint));
        }
    }

    @Override
    public void connectEndpoint(HttpClientContext httpClientContext) throws IOException {
        ConnectionEndpoint connectionEndpoint = this.ensureValid();
        if (!connectionEndpoint.isConnected()) {
            this.connectEndpoint(connectionEndpoint, httpClientContext);
        }
    }

    @Override
    public void disconnectEndpoint() throws IOException {
        ConnectionEndpoint connectionEndpoint = this.endpointRef.get();
        if (connectionEndpoint != null) {
            connectionEndpoint.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} endpoint closed", (Object)ConnPoolSupport.getId(connectionEndpoint));
            }
        }
    }

    @Override
    public void upgradeTls(HttpClientContext httpClientContext) throws IOException {
        ConnectionEndpoint connectionEndpoint = this.ensureValid();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} upgrading endpoint", (Object)ConnPoolSupport.getId(connectionEndpoint));
        }
        this.manager.upgrade(connectionEndpoint, httpClientContext);
    }

    @Override
    public EndpointInfo getEndpointInfo() {
        ConnectionEndpoint connectionEndpoint = this.endpointRef.get();
        if (connectionEndpoint != null) {
            return connectionEndpoint.getInfo();
        }
        return null;
    }

    @Override
    public ClassicHttpResponse execute(String string, ClassicHttpRequest classicHttpRequest, HttpClientContext httpClientContext) throws IOException, HttpException {
        return this.execute(string, classicHttpRequest, null, httpClientContext);
    }

    @Override
    public ClassicHttpResponse execute(String string, ClassicHttpRequest classicHttpRequest2, HttpResponseInformationCallback httpResponseInformationCallback, HttpClientContext httpClientContext) throws IOException, HttpException {
        ConnectionEndpoint connectionEndpoint = this.ensureValid();
        if (!connectionEndpoint.isConnected()) {
            this.connectEndpoint(connectionEndpoint, httpClientContext);
        }
        if (this.isExecutionAborted()) {
            throw new RequestFailedException("Request aborted");
        }
        Object object = httpClientContext.getRequestConfigOrDefault();
        if ((object = ((RequestConfig)object).getResponseTimeout()) != null) {
            connectionEndpoint.setSocketTimeout((Timeout)object);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(connectionEndpoint), (Object)string);
        }
        return connectionEndpoint.execute(string, classicHttpRequest2, (ClassicHttpRequest classicHttpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) -> this.requestExecutor.execute(classicHttpRequest, httpClientConnection, httpResponseInformationCallback, httpContext), (HttpContext)httpClientContext);
    }

    @Override
    public boolean isConnectionReusable() {
        return this.reusable;
    }

    @Override
    public void markConnectionReusable(Object object, TimeValue timeValue) {
        this.reusable = true;
        this.state = object;
        this.validDuration = timeValue;
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    private void discardEndpoint(ConnectionEndpoint connectionEndpoint) {
        try {
            connectionEndpoint.close(CloseMode.IMMEDIATE);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} endpoint closed", (Object)ConnPoolSupport.getId(connectionEndpoint));
            }
            return;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} discarding endpoint", (Object)ConnPoolSupport.getId(connectionEndpoint));
            }
            this.manager.release(connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
        }
    }

    @Override
    public void releaseEndpoint() {
        ConnectionEndpoint connectionEndpoint = this.endpointRef.getAndSet(null);
        if (connectionEndpoint != null) {
            if (this.reusable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} releasing valid endpoint", (Object)ConnPoolSupport.getId(connectionEndpoint));
                }
                this.manager.release(connectionEndpoint, this.state, this.validDuration);
                return;
            }
            this.discardEndpoint(connectionEndpoint);
        }
    }

    @Override
    public void discardEndpoint() {
        ConnectionEndpoint connectionEndpoint = this.endpointRef.getAndSet(null);
        if (connectionEndpoint != null) {
            this.discardEndpoint(connectionEndpoint);
        }
    }

    @Override
    public boolean cancel() {
        boolean bl2 = this.endpointRef.get() == null;
        ConnectionEndpoint connectionEndpoint = this.endpointRef.getAndSet(null);
        if (connectionEndpoint != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} cancel", (Object)ConnPoolSupport.getId(connectionEndpoint));
            }
            this.discardEndpoint(connectionEndpoint);
        }
        return !bl2;
    }

    @Override
    public ExecRuntime fork(CancellableDependency cancellableDependency) {
        return new InternalExecRuntime(this.log, this.manager, this.requestExecutor, cancellableDependency);
    }
}

